<?php
// view/users.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php'); // Redirect jika bukan admin
    exit;
}

 $activePage = 'users';
 $pageTitle = $lang[$current_lang]['users'] ?? 'Users';

// Ambil data lokasi untuk dropdown
 $stmtLoc = $pdo->query("SELECT name FROM locations ORDER BY name ASC");
 $locations = $stmtLoc->fetchAll(PDO::FETCH_ASSOC);

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'bn' ? 'active' : '' ?>" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> <?= $lang[$current_lang]['profile'] ?? 'Profile' ?></a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['users'] ?? 'Users Management' ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['manage_users_desc'] ?? 'Manage system users' ?></p>
            </div>
            <div>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addUserModal">
                    <i class="mdi mdi-plus"></i> <?= $lang[$current_lang]['add_new'] ?? 'Add New' ?>
                </button>
            </div>
        </div>

        <div class="card fade-in">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="tableUsers">
                        <thead>
                            <tr>
                                <th><?= $lang[$current_lang]['name'] ?? 'Name' ?></th>
                                <th><?= $lang[$current_lang]['username'] ?? 'Username' ?></th>
                                <th>Email</th>
                                <th><?= $lang[$current_lang]['location'] ?? 'Location' ?></th>
                                <th><?= $lang[$current_lang]['role'] ?? 'Role' ?></th>
                                <th><?= $lang[$current_lang]['status'] ?? 'Status' ?></th>
                                <th class="text-end"><?= $lang[$current_lang]['action'] ?? 'Action' ?></th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
<footer class="footer">
    <p>
        <?= htmlspecialchars($app_setting['footer_text'] ?? 'SmartWifi Voucher System v'.APP_VERSION) ?>
    </p>
</footer>
</main>
</div>

<!-- Modal Add User -->
<div class="modal fade" id="addUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="formAddUser">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="mdi mdi-account-plus me-2"></i><?= $lang[$current_lang]['add_user'] ?? 'Add User' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['full_name'] ?? 'Full Name' ?></label>
                        <input type="text" name="full_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['username'] ?? 'Username' ?></label>
                        <input type="text" name="username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['password'] ?? 'Password' ?></label>
                        <input type="password" name="password" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['location'] ?? 'Location' ?></label>
                        <select name="location" class="form-select">
                            <option value="">-- All Locations --</option>
                            <?php foreach($locations as $loc): ?>
                            <option value="<?= $loc['name'] ?>"><?= $loc['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label"><?= $lang[$current_lang]['role'] ?? 'Role' ?></label>
                            <select name="role" class="form-select" required>
                                <option value="admin">Admin</option>
                                <option value="maintenance">Maintenance</option>
                                <option value="guest">Guest</option>
                            </select>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label"><?= $lang[$current_lang]['status'] ?? 'Status' ?></label>
                            <select name="status" class="form-select" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?? 'Cancel' ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-check me-1"></i><?= $lang[$current_lang]['save'] ?? 'Save' ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Edit User -->
<div class="modal fade" id="editUserModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form id="formEditUser">
                <input type="hidden" name="id" id="edit_id">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="mdi mdi-account-edit me-2"></i><?= $lang[$current_lang]['edit_user'] ?? 'Edit User' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['full_name'] ?? 'Full Name' ?></label>
                        <input type="text" name="full_name" id="edit_full_name" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['username'] ?? 'Username' ?></label>
                        <input type="text" name="username" id="edit_username" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Email</label>
                        <input type="email" name="email" id="edit_email" class="form-control">
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['password'] ?? 'Password' ?> <small>(Leave blank to keep old)</small></label>
                        <input type="password" name="password" id="edit_password" class="form-control" placeholder="******">
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['location'] ?? 'Location' ?></label>
                        <select name="location" id="edit_location" class="form-select">
                            <option value="">-- All Locations --</option>
                            <?php foreach($locations as $loc): ?>
                            <option value="<?= $loc['name'] ?>"><?= $loc['name'] ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label"><?= $lang[$current_lang]['role'] ?? 'Role' ?></label>
                            <select name="role" id="edit_role" class="form-select" required>
                                <option value="admin">Admin</option>
                                <option value="maintenance">Maintenance</option>
                                <option value="guest">Guest</option>
                            </select>
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label"><?= $lang[$current_lang]['status'] ?? 'Status' ?></label>
                            <select name="status" id="edit_status" class="form-select" required>
                                <option value="active">Active</option>
                                <option value="inactive">Inactive</option>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?? 'Cancel' ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-check me-1"></i><?= $lang[$current_lang]['save'] ?? 'Save' ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    // Init DataTable
    var tableUsers = $('#tableUsers').DataTable({
        retrieve: true,
        processing: true,
        language: {
            search: "",
            searchPlaceholder: "<?= $lang[$current_lang]['search'] ?? 'Search...' ?>"
        },
        ajax: {
            url: '../get/get_users.php',
            type: 'GET',
            dataSrc: 'data'
        },
        columns: [
            { data: 'full_name' },
            { data: 'username' },
            { data: 'email' },
            { data: 'location' },
            { data: 'role' },
            { 
                data: 'status', 
                render: function(data, type, row) {
                    var badge = data == 'active' ? 'bg-success' : 'bg-danger';
                    return `<span class="badge ${badge}">${data}</span>`;
                }
            },
            { 
                data: null, 
                render: function(data, type, row) {
                    return `
                        <div class="d-flex gap-2 justify-content-end">
                            <button class="btn btn-warning btn-sm btn-edit" data-id="${row.id}" data-json='${JSON.stringify(row)}'>
                                <i class="mdi mdi-pencil"></i>
                            </button>
                            <button class="btn btn-danger btn-sm btn-delete" data-id="${row.id}">
                                <i class="mdi mdi-trash-can"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // Event: Click Edit
    $('#tableUsers').on('click', '.btn-edit', function() {
        var data = $(this).data('json');
        $('#edit_id').val(data.id);
        $('#edit_full_name').val(data.full_name);
        $('#edit_username').val(data.username);
        $('#edit_email').val(data.email);
        $('#edit_location').val(data.location);
        $('#edit_role').val(data.role);
        $('#edit_status').val(data.status);
        $('#edit_password').val(''); // Kosongkan password
        
        $('#editUserModal').modal('show');
    });

    // Event: Submit Add
    $('#formAddUser').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../post/add_user.php',
            method: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    $('#formAddUser')[0].reset();
                    $('#addUserModal').modal('hide');
                    tableUsers.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // Event: Submit Edit
    $('#formEditUser').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '../post/edit_user.php',
            method: 'POST',
            data: $(this).serialize(),
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    $('#editUserModal').modal('hide');
                    tableUsers.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // Event: Delete
    $('#tableUsers').on('click', '.btn-delete', function() {
        var id = $(this).data('id');
        if(confirm('<?= $lang[$current_lang]['confirm_delete'] ?? 'Are you sure?' ?>')) {
            $.ajax({
                url: '../post/delete_user.php',
                method: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(response) {
                    if(response.status === 'success') {
                        showToast(response.message, 'success');
                        tableUsers.ajax.reload();
                    } else {
                        showToast(response.message, 'error');
                    }
                }
            });
        }
    });
});
</script>