<?php
// view/dashboard.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';
 $user_id = $_SESSION['user_id'];

// --- LOGIKA DATA ---

// 1. Statistik Utama
if ($user_role === 'admin') {
    // ADMIN: Hitung semua data
    $stmt = $pdo->query("SELECT COUNT(*) FROM vouchers WHERE status = 'active'");
    $total_vouchers = $stmt->fetchColumn();

    $stmt = $pdo->query("SELECT COUNT(*) FROM penjualan_voucher WHERE tanggal = CURDATE()");
    $sales_today = $stmt->fetchColumn();

    $stmt = $pdo->query("SELECT SUM(harga) FROM penjualan_voucher WHERE tanggal = CURDATE()");
    $revenue_today = $stmt->fetchColumn() ?? 0;

    $stmt = $pdo->query("SELECT COUNT(*) FROM konsumen");
    $total_consumers = $stmt->fetchColumn();

    $stmt = $pdo->query("SELECT COUNT(*) FROM locations");
    $total_locations = $stmt->fetchColumn();
    
} else {
    // GUEST: Hitung data berdasarkan lokasi user
    // Cari ID Lokasi
    $stmtLoc = $pdo->prepare("SELECT id FROM locations WHERE name = ?");
    $stmtLoc->execute([$user_location]);
    $loc_id = $stmtLoc->fetchColumn();

    // Voucher Aktif
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM vouchers WHERE location_id = ? AND status = 'active'");
    $stmt->execute([$loc_id]);
    $total_vouchers = $stmt->fetchColumn();

    // Penjualan Hari Ini
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM penjualan_voucher WHERE lokasi = ? AND tanggal = CURDATE()");
    $stmt->execute([$user_location]);
    $sales_today = $stmt->fetchColumn();

    // Pendapatan Hari Ini
    $stmt = $pdo->prepare("SELECT SUM(harga) FROM penjualan_voucher WHERE lokasi = ? AND tanggal = CURDATE()");
    $stmt->execute([$user_location]);
    $revenue_today = $stmt->fetchColumn() ?? 0;

    // Konsumen
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM konsumen WHERE lokasi = ?");
    $stmt->execute([$user_location]);
    $total_consumers = $stmt->fetchColumn();

    // Lokasi (Info sendiri)
    $total_locations = 1; // Hanya 1 lokasi
}

// 2. Aktivitas Terbaru
if ($user_role === 'admin') {
    // Admin lihat semua aktivitas
    $stmt_act = $pdo->query("SELECT * FROM activity_log ORDER BY created_at DESC LIMIT 5");
} else {
    // Guest lihat aktivitas miliknya
    $stmt_act = $pdo->prepare("SELECT * FROM activity_log WHERE user_id = ? ORDER BY created_at DESC LIMIT 5");
    $stmt_act->execute([$user_id]);
}
 $activities = $stmt_act->fetchAll(PDO::FETCH_ASSOC);

// 3. Penjualan Terbaru (Mengganti Low Stock Items)
if ($user_role === 'admin') {
    $stmt_sales = $pdo->query("SELECT p.*, u.full_name as seller_name 
                               FROM penjualan_voucher p 
                               LEFT JOIN users u ON p.dibuat_oleh = u.username
                               ORDER BY p.created_at DESC LIMIT 5");
} else {
    $stmt_sales = $pdo->prepare("SELECT * FROM penjualan_voucher 
                                 WHERE lokasi = ? 
                                 ORDER BY created_at DESC LIMIT 5");
    $stmt_sales->execute([$user_location]);
}
 $recent_sales = $stmt_sales->fetchAll(PDO::FETCH_ASSOC);

// 4. Ambil Currency dari Database
 $currency_symbol = $app_setting['currency'] ?? 'Rp';

// Include Header & Sidebar
require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>
        
<!-- Main Content -->
<main class="main-content">
    <!-- Header Top Bar -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle">
                <i class="mdi mdi-menu"></i>
            </button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $lang[$current_lang]['dashboard'] ?? 'Dashboard' ?></span>
            </nav>
        </div>
        <div class="header-right">
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <!-- PERBAIKAN: Style dropdown tema -->
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <!-- PERBAIKAN: Style dropdown tema -->
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <!-- PERBAIKAN: Style dropdown tema -->
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider" style="border-color: var(--primary);"></li>
                    <li><a class="dropdown-item text-danger" style="color: #e94560 !important;" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?? 'Logout' ?></a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['welcome'] ?? 'Welcome' ?>, <?= htmlspecialchars($_SESSION['name']) ?></h1>
                <p class="page-subtitle">
                    <?= date('l, d F Y') ?> 
                    <?php if($user_role !== 'admin'): ?>
                         - Location: <strong><?= htmlspecialchars($user_location) ?></strong>
                    <?php endif; ?>
                </p>
            </div>
            
            <?php if ($user_role === 'admin'): ?>
            <a href="voucher.php" class="btn btn-primary">
                <i class="mdi mdi-plus"></i> Add Voucher
            </a>
            <?php else: ?>
            <a href="konsumen.php" class="btn btn-primary">
                <i class="mdi mdi-cart"></i> Sell Voucher
            </a>
            <?php endif; ?>
        </div>
        
        <!-- Statistics -->
        <div class="stat-grid fade-in">
            <div class="stat-card">
                <div class="stat-icon">
                    <i class="mdi mdi-ticket-percent"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($total_vouchers) ?></h3>
                    <p>Active Vouchers</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #00d26a, #0d2818);">
                    <i class="mdi mdi-cash"></i>
                </div>
                <div class="stat-content">
                    <!-- PERBAIKAN: Gunakan currency dari DB -->
                    <h3><?= htmlspecialchars($currency_symbol) ?> <?= number_format($revenue_today) ?></h3>
                    <p>Revenue Today</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #64ffda, #0a192f);">
                    <i class="mdi mdi-cart-outline"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($sales_today) ?></h3>
                    <p>Sales Today</p>
                </div>
            </div>
            <div class="stat-card">
                <div class="stat-icon" style="background: linear-gradient(135deg, #e94560, #16213e);">
                    <i class="mdi mdi-account-group"></i>
                </div>
                <div class="stat-content">
                    <h3><?= number_format($total_consumers) ?></h3>
                    <p>Total Consumers</p>
                </div>
            </div>
        </div>
        
        <div class="row">
            <!-- Recent Activity -->
            <div class="col-lg-6 mb-4">
                <div class="card fade-in">
                    <div class="card-header">
                        <h5 class="card-title">
                            <i class="mdi mdi-history me-2"></i>
                            <?= $lang[$current_lang]['recent_activity'] ?? 'Recent Activity' ?>
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="list-group list-group-flush">
                            <?php if (empty($activities)): ?>
                            <div class="p-4 text-center text-muted">
                                <i class="mdi mdi-information-outline mdi-36px d-block mb-2"></i>
                                No recent activity
                            </div>
                            <?php else: ?>
                            <?php foreach ($activities as $activity): ?>
                            <div class="list-group-item" style="border-color: var(--card-border);">
                                <div class="d-flex align-items-center gap-3">
                                    <div class="stat-icon" style="width: 36px; height: 36px; font-size: 16px;">
                                        <i class="mdi <?= $activity['icon'] ?? 'mdi-information' ?>"></i>
                                    </div>
                                    <div class="flex-grow-1">
                                        <p class="mb-0"><?= htmlspecialchars($activity['description']) ?></p>
                                        <small class="text-muted"><?= date('d M Y H:i', strtotime($activity['created_at'])) ?></small>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Recent Sales -->
            <div class="col-lg-6 mb-4">
                <div class="card fade-in">
                    <div class="card-header">
                        <h5 class="card-title">
                            <i class="mdi mdi-receipt me-2 text-info"></i>
                            Recent Sales
                        </h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table class="table mb-0">
                                <thead>
                                    <tr>
                                        <th>Voucher</th>
                                        <th>Consumer</th>
                                        <th>Price</th>
                                        <?php if($user_role === 'admin'): ?><th>Location</th><?php endif; ?>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if (empty($recent_sales)): ?>
                                    <tr>
                                        <td colspan="<?= $user_role === 'admin' ? 4 : 3 ?>" class="text-center text-muted py-4">
                                            <i class="mdi mdi-cart-off mdi-24px d-block mb-2"></i>
                                            No sales recorded
                                        </td>
                                    </tr>
                                    <?php else: ?>
                                    <?php foreach ($recent_sales as $sale): ?>
                                    <tr>
                                        <td><span class="badge bg-primary"><?= $sale['kode_voucher'] ?></span></td>
                                        <td><?= htmlspecialchars($sale['nama_konsumen']) ?></td>
                                        <!-- PERBAIKAN: Gunakan currency dari DB -->
                                        <td><?= htmlspecialchars($currency_symbol) ?> <?= number_format($sale['harga']) ?></td>
                                        <?php if($user_role === 'admin'): ?>
                                        <td><span class="badge bg-secondary"><?= $sale['lokasi'] ?></span></td>
                                        <?php endif; ?>
                                    </tr>
                                    <?php endforeach; ?>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="footer">
        <!-- PERBAIKAN: Ambil footer dari database -->
        <p><?= htmlspecialchars($app_setting['footer_text'] ?? ('SmartWifi Voucher System v' . APP_VERSION)) ?></p>
    </footer>
</main>
</div> <!-- End app-wrapper -->

<?php 
// Include Footer (Scripts & Closing Tags)
require_once '../includes/footer.php'; 
?>