<?php
// post/edit_location.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $id = $_POST['id'] ?? 0;
 $name = $_POST['name'] ?? '';

if (empty($name)) {
    echo json_encode(['status' => 'error', 'message' => 'Name is required']);
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE locations SET name = ? WHERE id = ?");
    $stmt->execute([$name, $id]);
    
    echo json_encode(['status' => 'success', 'message' => 'Location updated successfully']);
} catch (PDOException $e) {
    if ($e->errorInfo[1] == 1062) {
        echo json_encode(['status' => 'error', 'message' => 'Location name already exists']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
    }
}