<?php
// post/add_voucher.php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ambil data dari form
    $code = $_POST['code'];
    $location_id = !empty($_POST['location_id']) ? $_POST['location_id'] : NULL;
    
    // Sesuaikan dengan nama input di form dan database baru
    $nama_paket = $_POST['nama_paket'];       // Input baru
    $durasi_hari = $_POST['durasi_hari'];     // Input baru (menggantikan duration)
    $price = $_POST['price'];
    $tanggal_pembuatan = $_POST['tanggal_pembuatan']; // Input baru (menggantikan expired_at)
    
    $link = $_POST['link'] ?? '';
    $status = $_POST['status'] ?? 'active';

    try {
        // Query INSERT disesuaikan dengan kolom baru: nama_paket, durasi_hari, tanggal_pembuatan
        $stmt = $pdo->prepare("INSERT INTO vouchers (code, location_id, nama_paket, durasi_hari, price, tanggal_pembuatan, link, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$code, $location_id, $nama_paket, $durasi_hari, $price, $tanggal_pembuatan, $link, $status]);
        
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['add_success'] ?? 'Voucher berhasil ditambahkan',
            'type' => 'success'
        ];
    } catch (PDOException $e) {
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['add_error'] ?? 'Gagal menambahkan voucher: ' . $e->getMessage(),
            'type' => 'error'
        ];
    }
}

header('Location: ../view/voucher.php');
exit;
?>