<?php
// post/add_user.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $username = $_POST['username'] ?? '';
 $password = $_POST['password'] ?? '';
 $full_name = $_POST['full_name'] ?? '';
 $email = $_POST['email'] ?? '';
 $location = $_POST['location'] ?? NULL;
 $role = $_POST['role'] ?? 'guest';
 $status = $_POST['status'] ?? 'active';

// Cek username duplikat
 $stmtCheck = $pdo->prepare("SELECT id FROM users WHERE username = ?");
 $stmtCheck->execute([$username]);
if($stmtCheck->rowCount() > 0) {
    echo json_encode(['status' => 'error', 'message' => 'Username already exists']);
    exit;
}

try {
    $hashed_password = password_hash($password, PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("INSERT INTO users (username, password, full_name, email, location, role, status) VALUES (?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$username, $hashed_password, $full_name, $email, $location, $role, $status]);
    
    echo json_encode(['status' => 'success', 'message' => 'User added successfully']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}