<?php
// index.php
require_once 'config/config.php';

if (isset($_SESSION['user_id'])) {
    header('Location: view/dashboard.php');
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';
    
    // Ambil data user termasuk pengaturan
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ? AND status = 'active'");
    $stmt->execute([$username]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
        if ($user && password_verify($password, $user['password'])) {
            // Simpan data user ke session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['name'] = $user['full_name'];
            
            // TAMBAHKAN BARIS INI
            $_SESSION['location'] = $user['location'] ?? 'Unspecified';
            // ---------------------

            // SIMPAN PENGATURAN DARI DATABASE KE SESSION
            $_SESSION['theme'] = $user['theme'] ?? 'black';
            $_SESSION['lang'] = $user['lang'] ?? 'id';
            $_SESSION['text_size'] = $user['text_size'] ?? 'm';
            $_SESSION['btn_size'] = $user['btn_size'] ?? 'm';
            $_SESSION['icon_size'] = $user['icon_size'] ?? 'm';
            
            header('Location: view/dashboard.php');
            exit;
        } else {
        // Pastikan variabel $current_lang dan $error terdefinisi dengan aman
        $current_lang = $current_lang ?? 'id';
        $error = ($current_lang === 'id') ? 'Nama pengguna atau kata sandi salah' : 'Invalid username or password';
    }
}

// Fallback untuk variabel view jika belum login (POST gagal atau akses langsung)
 $current_lang = $current_lang ?? 'id';
 $current_theme = $current_theme ?? 'black';
// Pastikan array $lang ada (biasanya di config, ini fallback sederhana)
 $lang = $lang ?? [
    'id' => ['username' => 'Nama Pengguna', 'password' => 'Kata Sandi', 'login_btn' => 'Masuk'],
    'en' => ['username' => 'Username', 'password' => 'Password', 'login_btn' => 'Login']
];
?>
<!DOCTYPE html>
<html lang="<?= $current_lang ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= defined('APP_NAME') ? APP_NAME : 'App' ?> - Login</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/@mdi/font@7.2.96/css/materialdesignicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Space+Grotesk:wght@300;400;500;600;700&family=JetBrains+Mono:wght@400;500;600&display=swap" rel="stylesheet">
    <!-- Pastikan file CSS ini ada di folder Anda -->
    <link href="assets/css/dinar.css" rel="stylesheet">
    
    <style>
        /* Wrapper */
        .input-wrapper {
            position: relative;
        }

        /* Icon di sebelah kiri */
        .input-icon {
            position: absolute;
            top: 50%;
            left: 1rem;
            transform: translateY(-50%);
            z-index: 5;
            pointer-events: none; /* Agar klik tembus ke input */
            color: var(--bs-body-color);
            opacity: 0.7;
        }

        /* Input: Geser teks ke kanan agar tidak tertutup Icon */
        .input-with-icon {
            padding-left: 3rem !important; 
        }
        
        /* Label: Sesuaikan posisi awal */
        .input-wrapper > label {
            padding-left: 3rem !important; /* Geser Label agar sejajar dengan teks input */
            z-index: 1; /* Pastikan Label di atas input */
        }

        /* --- PERBAIKAN UTAMA (AGAR LABEL TIDAK MENIMPA TEKS) --- */
        
        /* Saat Input di-klik (focus) atau sudah ada isinya, Label wajib naik */
        .input-wrapper > .form-control:focus ~ label,
        .input-wrapper > .form-control:not(:placeholder-shown) ~ label {
            /* Kita perkecil ukuran font dan geser ke atas (-0.5rem) */
            transform: scale(0.85) translateY(-0.5rem) !important;
            opacity: 1 !important; /* Pastikan label tetap terlihat */
            background-color: transparent; /* Hindari background label menutupi border jika ada */
        }

        /* -------------------------------------------------------- */

        /* Tombol Toggle Password */
        .password-toggle-btn {
            position: absolute;
            top: 50%;
            right: 1rem;
            transform: translateY(-50%);
            z-index: 5;
            background: none;
            border: none;
            cursor: pointer;
            color: var(--bs-body-color);
            padding: 0;
            display: flex;
            align-items: center;
        }
    </style>
</head>
<body class="login-page" data-theme="<?= $current_theme ?>">
    <!-- Animated Background -->
    <div class="login-bg">
        <div class="particles" id="particles"></div>
        <div class="gradient-orb orb-1"></div>
        <div class="gradient-orb orb-2"></div>
        <div class="gradient-orb orb-3"></div>
    </div>

    <div class="login-container">
        <div class="login-card">
            <div class="login-header">
                <div class="logo-container">
                    <div class="logo-icon">
                        <svg viewBox="0 0 48 48" fill="none">
                            <path d="M24 4L42 14V34L24 44L6 34V14L24 4Z" stroke="currentColor" stroke-width="2" fill="none"/>
                            <path d="M24 14L33 19.5V30.5L24 36L15 30.5V19.5L24 14Z" fill="currentColor" opacity="0.3"/>
                            <circle cx="24" cy="24" r="4" fill="currentColor"/>
                        </svg>
                    </div>
                    <div class="logo-text">
                        <h1>SpareParts</h1>
                        <span>Management System</span>
                    </div>
                </div>
                <p class="tagline">Tissue Converting Machine Solutions</p>
            </div>

            <form method="POST" class="login-form" id="loginForm">
                <?php if (isset($error)): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="mdi mdi-alert-circle me-2"></i><?= $error ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
                <?php endif; ?>

                <!-- Username Input -->
                <div class="form-floating mb-4 input-wrapper">
                    <i class="mdi mdi-account input-icon"></i>
                    <input type="text" class="form-control input-with-icon" id="username" name="username" placeholder="Username" required>
                    <label for="username"><?= $lang[$current_lang]['username'] ?? 'Username' ?></label>
                </div>

                <!-- Password Input -->
                <div class="form-floating mb-4 input-wrapper">
                    <i class="mdi mdi-lock input-icon"></i>
                    <input type="password" class="form-control input-with-icon" id="password" name="password" placeholder="Password" required>
                    <label for="password"><?= $lang[$current_lang]['password'] ?? 'Password' ?></label>
                    
                    <!-- Tombol toggle password diposisikan absolute -->
                    <button type="button" class="password-toggle-btn" onclick="togglePassword()">
                        <i class="mdi mdi-eye" id="eyeIcon"></i>
                    </button>
                </div>

                <div class="form-options mb-4">
                    <div class="dropdown">
                        <button class="btn btn-link dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="mdi mdi-translate"></i> <?= strtoupper($current_lang) ?>
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li><a class="dropdown-item" href="get/change_lang.php?lang=id">Indonesia</a></li>
                            <li><a class="dropdown-item" href="get/change_lang.php?lang=en">English</a></li>
                            <li><a class="dropdown-item" href="get/change_lang.php?lang=bn">বাংলা (Bangladesh)</a></li>
                        </ul>
                    </div>
                    <div class="dropdown">
                        <button class="btn btn-link dropdown-toggle" type="button" data-bs-toggle="dropdown">
                            <i class="mdi mdi-palette"></i> Theme
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end theme-selector">
                            <li><a class="dropdown-item" href="get/change_theme.php?theme=black" data-theme="black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                            <li><a class="dropdown-item" href="get/change_theme.php?theme=green" data-theme="green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                            <li><a class="dropdown-item" href="get/change_theme.php?theme=blue" data-theme="blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                            <li><a class="dropdown-item" href="get/change_theme.php?theme=ungu" data-theme="ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                            <li><a class="dropdown-item" href="get/change_theme.php?theme=biru_muda" data-theme="biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                        </ul>
                    </div>
                </div>

                <button type="submit" class="btn btn-primary btn-login w-100">
                    <span class="btn-text"><?= $lang[$current_lang]['login_btn'] ?? 'Login' ?></span>
                    <span class="btn-loader"><i class="mdi mdi-loading mdi-spin"></i></span>
                </button>
            </form>

            <div class="login-footer">
                <div class="machine-icon">
                    <i class="mdi mdi-cog-outline"></i>
                    <i class="mdi mdi-cog-outline cog-2"></i>
                </div>
                <p>Version <?= defined('APP_VERSION') ? APP_VERSION : '1.0' ?></p>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/dinar.js"></script>
    <script>
        // Create floating particles
        function createParticles() {
            const container = document.getElementById('particles');
            if(!container) return;
            
            for (let i = 0; i < 50; i++) {
                const particle = document.createElement('div');
                particle.className = 'particle';
                particle.style.cssText = `
                    left: ${Math.random() * 100}%;
                    top: ${Math.random() * 100}%;
                    width: ${Math.random() * 4 + 2}px;
                    height: ${Math.random() * 4 + 2}px;
                    animation-delay: ${Math.random() * 20}s;
                    animation-duration: ${Math.random() * 30 + 20}s;
                `;
                container.appendChild(particle);
            }
        }
        createParticles();

        // Login form animation
        document.getElementById('loginForm').addEventListener('submit', function(e) {
            const btn = this.querySelector('.btn-login');
            btn.classList.add('loading');
            btn.disabled = true;
        });

        function togglePassword() {
            const input = document.getElementById('password');
            const icon = document.getElementById('eyeIcon');
            if (input.type === 'password') {
                input.type = 'text';
                icon.className = 'mdi mdi-eye-off';
            } else {
                input.type = 'password';
                icon.className = 'mdi mdi-eye';
            }
        }
    </script>
</body>
</html>