<?php
// get/get_report_data.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['data' => [], 'count' => 0, 'total' => 0]);
    exit;
}

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';

 $start_date = $_GET['start_date'] ?? date('Y-m-01');
 $end_date = $_GET['end_date'] ?? date('Y-m-d');
 $filter_location = $_GET['location'] ?? '';

try {
    $sql_where = "WHERE tanggal BETWEEN ? AND ?";
    $params = [$start_date, $end_date];

    // Logic Role
    if ($user_role !== 'admin') {
        // Guest: Paksa filter lokasinya
        $sql_where .= " AND lokasi = ?";
        $params[] = $user_location;
    } else {
        // Admin: Jika pilih lokasi spesifik
        if (!empty($filter_location)) {
            $sql_where .= " AND lokasi = ?";
            $params[] = $filter_location;
        }
    }

    // Hitung Total
    $stmtCount = $pdo->prepare("SELECT COUNT(*) as count, SUM(harga) as total FROM penjualan_voucher $sql_where");
    $stmtCount->execute($params);
    $summary = $stmtCount->fetch(PDO::FETCH_ASSOC);

    // Ambil Data
    $stmtData = $pdo->prepare("SELECT * FROM penjualan_voucher $sql_where ORDER BY tanggal DESC");
    $stmtData->execute($params);
    $data = $stmtData->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'data' => $data,
        'count' => $summary['count'] ?? 0,
        'total' => $summary['total'] ?? 0
    ]);

} catch (PDOException $e) {
    echo json_encode(['data' => [], 'count' => 0, 'total' => 0]);
}