<?php
// get/get_konsumen.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['data' => []]);
    exit;
}

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';

try {
    $sql = "SELECT * FROM konsumen";
    
    // Jika BUKAN Admin, filter lokasi
    if ($user_role !== 'admin') {
        $sql .= " WHERE lokasi = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$user_location]);
    } else {
        // Jika Admin, tampilkan semua
        $sql .= " ORDER BY id DESC";
        $stmt = $pdo->query($sql);
    }

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $data]);
} catch (PDOException $e) {
    echo json_encode(['data' => []]);
}