<?php
// view/reset.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'reset';
 $pageTitle = $lang[$current_lang]['reset_data'] ?? 'Reset Data';

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Custom Style -->
<style>
    .form-control, .form-select {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border: 1px solid var(--primary) !important;
    }
    .custom-checkbox {
        width: 18px;
        height: 18px;
        cursor: pointer;
        accent-color: var(--accent);
    }
</style>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider" style="border-color: var(--primary);"></li>
                    <li><a class="dropdown-item text-danger" style="color: #e94560 !important;" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['reset_data'] ?? 'Reset Data' ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['reset_desc'] ?? 'Manage used vouchers and clear data' ?></p>
            </div>
        </div>

        <!-- Card 1: Reset Voucher Status -->
        <div class="card fade-in mb-4">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="card-title mb-0">
                    <i class="mdi mdi-recycle me-2"></i>
                    Reset Voucher Status
                </h5>
                <div class="d-flex gap-2">
                    <button type="button" class="btn btn-success btn-sm" id="btnResetSelected">
                        <i class="mdi mdi-refresh"></i> Set Active
                    </button>
                    <button type="button" class="btn btn-danger btn-sm" id="btnDeleteSelected">
                        <i class="mdi mdi-trash-can"></i> Delete
                    </button>
                </div>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="tableReset">
                        <thead>
                            <tr>
                                <th style="width: 40px;">
                                    <input type="checkbox" class="custom-checkbox" id="checkAll">
                                </th>
                                <th>Code</th>
                                <th>Paket</th>
                                <th>Location</th>
                                <th>Status</th>
                                <th>Created</th>
                            </tr>
                        </thead>
                        <tbody>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Card 2: Global Data Wipe (Danger Zone) -->
        <div class="card fade-in border-danger">
            <div class="card-header bg-danger text-white">
                <h5 class="card-title mb-0">
                    <i class="mdi mdi-alert-octagon me-2"></i>
                    Danger Zone
                </h5>
            </div>
            <div class="card-body">
                <p class="text-muted">Use with caution. These actions cannot be undone.</p>
                <form id="formGlobalReset">
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" value="konsumen" name="reset_table[]" id="resetKonsumen">
                        <label class="form-check-label" for="resetKonsumen" style="color: var(--text);">
                            Delete All Consumers Data
                        </label>
                    </div>
                    <div class="form-check mb-2">
                        <input class="form-check-input" type="checkbox" value="penjualan_voucher" name="reset_table[]" id="resetSales">
                        <label class="form-check-label" for="resetSales" style="color: var(--text);">
                            Delete All Sales History
                        </label>
                    </div>
                    <div class="form-check mb-3">
                        <input class="form-check-input" type="checkbox" value="vouchers" name="reset_table[]" id="resetVouchers">
                        <label class="form-check-label" for="resetVouchers" style="color: var(--text);">
                            Delete All Vouchers
                        </label>
                    </div>

                    <div class="mb-3">
                        <label class="form-label" style="color: var(--text);">Type "<strong>CONFIRM</strong>" to proceed</label>
                        <!-- ID unik untuk input ini -->
                        <input type="text" id="confirmTextGlobal" name="confirm_text" class="form-control" placeholder="Type CONFIRM" autocomplete="off">
                    </div>

                    <button type="submit" class="btn btn-danger">
                        <i class="mdi mdi-nuke"></i> Execute Wipe Data
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <p><?= htmlspecialchars($app_setting['footer_text'] ?? ('SmartWifi Voucher System v' . APP_VERSION)) ?></p>
    </footer>
</main>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    // 1. Init DataTable
    var tableReset = $('#tableReset').DataTable({
        retrieve: true,
        processing: true,
        language: {
            search: "",
            searchPlaceholder: "Search..."
        },
        ajax: {
            url: '../get/get_non_active_vouchers.php',
            type: 'GET',
            dataSrc: 'data'
        },
        columns: [
            { 
                data: null, 
                orderable: false,
                render: function(data, type, row) {
                    return `<input type="checkbox" class="custom-checkbox row-check" data-id="${row.id}">`;
                }
            },
            { data: 'code' },
            { data: 'nama_paket' },
            { data: 'location_name' },
            { 
                data: 'status', 
                render: function(data, type, row) {
                    var badge = data == 'used' ? 'bg-warning' : 'bg-danger';
                    return `<span class="badge ${badge}">${data}</span>`;
                }
            },
            { data: 'created_at' }
        ]
    });

    // 2. Check All Logic
    $('#checkAll').on('click', function() {
        $('.row-check').prop('checked', this.checked);
    });

    // 3. Reset Selected (Set Active)
    $('#btnResetSelected').on('click', function() {
        var ids = [];
        $('.row-check:checked').each(function() {
            ids.push($(this).data('id'));
        });

        if(ids.length === 0) {
            showToast('Pilih data terlebih dahulu', 'error');
            return;
        }

        if(confirm('Reset status voucher terpilih menjadi Active?')) {
            $.ajax({
                url: '../post/reset_status_voucher.php',
                method: 'POST',
                data: { ids: ids },
                dataType: 'json',
                success: function(response) {
                    if(response.status === 'success') {
                        showToast(response.message, 'success');
                        tableReset.ajax.reload();
                        $('#checkAll').prop('checked', false);
                    } else {
                        showToast(response.message, 'error');
                    }
                }
            });
        }
    });

    // 4. Delete Selected
    $('#btnDeleteSelected').on('click', function() {
        var ids = [];
        $('.row-check:checked').each(function() {
            ids.push($(this).data('id'));
        });

        if(ids.length === 0) {
            showToast('Pilih data terlebih dahulu', 'error');
            return;
        }

        if(confirm('Hapus data terpilih secara permanen?')) {
            $.ajax({
                url: '../post/delete_selected_voucher.php',
                method: 'POST',
                data: { ids: ids },
                dataType: 'json',
                success: function(response) {
                    if(response.status === 'success') {
                        showToast(response.message, 'success');
                        tableReset.ajax.reload();
                        $('#checkAll').prop('checked', false);
                    } else {
                        showToast(response.message, 'error');
                    }
                }
            });
        }
    });

        // 5. Global Reset Form - FIXED VALIDATION & DEBUGGING
    $('#formGlobalReset').on('submit', function(e) {
        e.preventDefault();
        
        // Ambil nilai input berdasarkan ID
        var confirmInput = $('#confirmTextGlobal').val();
        
        // Validasi: Ubah ke huruf besar dan hapus spasi kiri-kanan
        if(!confirmInput || confirmInput.toUpperCase().trim() !== 'CONFIRM') {
            showToast('Konfirmasi teks salah! Ketik "CONFIRM" dengan benar.', 'error');
            return;
        }

        var formData = $(this).serialize();

        $.ajax({
            url: '../post/global_reset.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    // Kosongkan input setelah sukses
                    $('#confirmTextGlobal').val('');
                    $('#formGlobalReset input[type=checkbox]').prop('checked', false);
                    // Reload tabel jika ada data voucher yang berubah
                    tableReset.ajax.reload(); 
                } else {
                    showToast(response.message, 'error');
                }
            },
            error: function(xhr, status, error) {
                // DEBUGGING: Tampilkan response text dari server di console
                console.log("Server Response Text:", xhr.responseText);
                
                // Coba parse jika response adalah JSON error, jika tidak tampilkan generic error
                try {
                    var resp = JSON.parse(xhr.responseText);
                    showToast("Error: " + resp.message, 'error');
                } catch(e) {
                    // Jika response bukan JSON (misal: PHP Fatal Error HTML)
                    showToast("Server Error (500). Check Console (F12) for details.", 'error');
                }
            }
        });
    });
});
</script>