<?php
// view/add_router.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'add_router';
 $pageTitle = 'Manage Routers';

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- CSS KHUSUS UNTUK PERBAIKAN VISIBILITAS HEADER -->
<style>
    /* 1. Memastikan Container Header kanan MUNCUL */
    .header-right {
        display: flex !important;
        visibility: visible !important;
        opacity: 1 !important;
        position: relative !important;
        z-index: 1050 !important; /* Pastikan di atas elemen lain */
    }

    /* 2. Memastikan Tombol-tombol di dalamnya MUNCUL */
    .header-btn {
        display: inline-flex !important;
        visibility: visible !important;
        opacity: 1 !important;
        width: 40px;
        height: 40px;
        justify-content: center;
        align-items: center;
        border-radius: 50%;
        background-color: rgba(255,255,255,0.1);
        color: var(--text) !important;
        border: none;
        cursor: pointer;
        font-size: 1.2rem;
        transition: 0.3s;
        text-decoration: none;
    }

    .header-btn:hover {
        background-color: var(--primary);
        color: #fff !important;
    }

    /* 3. Perbaikan Dropdown agar tidak tertutup */
    .dropdown-menu {
        z-index: 1060 !important;
        background-color: var(--secondary) !important;
        border: 1px solid var(--primary) !important;
    }
    
    .dropdown-item {
        color: var(--text) !important;
    }

    /* Perbaikan Umum Header */
    .header {
        display: flex !important;
        justify-content: space-between !important;
        align-items: center !important;
        background-color: var(--secondary) !important;
        padding: 0 20px;
        height: 70px;
    }
</style>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php">Home</a>
                <i class="mdi mdi-chevron-right"></i>
                <span>Router Management</span>
            </nav>
        </div>
        
        <!-- HEADER RIGHT: DIPASTIKAN MUNCUL -->
        <div class="header-right">
             <!-- Dropdown Bahasa -->
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
            
            <!-- Dropdown Tema -->
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>

            <!-- Dropdown User -->
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown" aria-expanded="false"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title">Manage Routers</h1>
                <p class="page-subtitle">Connect and manage MikroTik routers</p>
            </div>
        </div>
        
        <div class="row">
            <div class="col-lg-8 col-md-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title" id="formTitle">Add New Router</h3>
                        <button type="button" class="btn btn-sm btn-secondary float-end" id="btnResetForm" style="display:none;">Cancel Edit</button>
                    </div>
                    <div class="card-body">
                        <form id="formRouter">
                            <input type="hidden" name="id" id="routerId">
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">Router Name</label>
                                    <input type="text" name="name" id="routerName" class="form-control" placeholder="e.g. Main Server" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label class="form-label">IP Address</label>
                                    <input type="text" name="ip" id="routerIp" class="form-control" placeholder="192.168.88.1" required>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">API Port</label>
                                    <input type="number" name="port" id="routerPort" class="form-control" value="8728" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Username</label>
                                    <input type="text" name="user" id="routerUser" class="form-control" placeholder="admin" required>
                                </div>
                                <div class="col-md-4 mb-3">
                                    <label class="form-label">Password</label>
                                    <input type="password" name="pass" id="routerPass" class="form-control" placeholder="password" required>
                                </div>
                            </div>

                            <div class="d-flex gap-2 mt-4">
                                <button type="button" class="btn btn-secondary" id="btnTestConnection">
                                    <i class="mdi mdi-ethernet-cable"></i> Test Connection
                                </button>
                                <button type="submit" class="btn btn-primary" id="btnSubmitRouter">
                                    <i class="mdi mdi-content-save"></i> Save Router
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>

        <!-- List Routers -->
        <div class="row mt-4">
            <div class="col-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">Connected Routers</h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-hover" id="routerTable">
                            <thead>
                                <tr>
                                    <th>Name</th>
                                    <th>IP Address</th>
                                    <th>Port</th>
                                    <th>Connectivity</th>
                                    <th>Status</th>
                                    <th>Action</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    
    var tableRouter;

    // 1. Test Connection Logic
    $('#btnTestConnection').on('click', function() {
        var btn = $(this);
        var originalText = btn.html();
        var ip = $('#routerIp').val();
        var port = $('#routerPort').val();

        if(!ip || !port) { showToast('IP and Port required', 'error'); return; }

        btn.prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> Connecting...');

        $.ajax({
            url: '../post/test_router_connection.php',
            method: 'POST',
            data: { ip: ip, port: port },
            dataType: 'json',
            success: function(response) {
                btn.prop('disabled', false).html(originalText);
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    if($('#routerId').val()) tableRouter.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                    if($('#routerId').val()) tableRouter.ajax.reload();
                }
            },
            error: function() {
                btn.prop('disabled', false).html(originalText);
                showToast('Server error', 'error');
            }
        });
    });

    // 2. Submit Form
    $('#formRouter').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();
        var btn = $('#btnSubmitRouter');
        var isEdit = $('#routerId').val() !== "";
        var url = isEdit ? '../post/update_router.php' : '../post/save_router.php';

        btn.prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> Saving...');

        $.ajax({
            url: url,
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                btn.prop('disabled', false).html(isEdit ? '<i class="mdi mdi-content-save"></i> Update Router' : '<i class="mdi mdi-content-save"></i> Save Router');
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    resetForm();
                    tableRouter.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            },
            error: function() {
                btn.prop('disabled', false).html('<i class="mdi mdi-content-save"></i> Save');
                showToast('Error processing request', 'error');
            }
        });
    });

    // 3. DataTables Initialization
    tableRouter = $('#routerTable').DataTable({
        processing: true,
        ajax: { url: '../get/get_routers.php', type: 'GET', dataSrc: 'data' },
        columns: [
            { data: 'name' },
            { data: 'ip' },
            { data: 'port' },
            { 
                data: 'connectivity',
                render: function(data) {
                    if(data === 'connected') {
                        return '<span class="badge bg-success"><i class="mdi mdi-check-circle"></i> Connected</span>';
                    } else if(data === 'disconnected') {
                        return '<span class="badge bg-danger"><i class="mdi mdi-close-circle"></i> Disconnected</span>';
                    } else {
                        return '<span class="badge bg-secondary">Unknown</span>';
                    }
                }
            },
            { 
                data: 'status',
                render: function(data) {
                    return data === 'active' 
                        ? '<span class="badge bg-primary">Active</span>' 
                        : '<span class="badge bg-dark">Inactive</span>';
                }
            },
            { 
                data: null,
                render: function(data) {
                    // TOMBOL OPEN: Buka Dashboard MikroTik (Target Blank)
                    var btnOpen = `<a href="http://${data.ip}" target="_blank" class="btn btn-sm btn-info" title="Open Dashboard">
                                        <i class="mdi mdi-open-in-new"></i>
                                    </a>`;

                    // TOMBOL STOP: Hanya muncul jika status active
                    var btnStop = '';
                    if(data.status === 'active') {
                        btnStop = `<button class="btn btn-sm btn-danger btn-stop-router" data-id="${data.id}" title="Stop Router">
                                        <i class="mdi mdi-stop"></i>
                                    </button>`;
                    } else {
                         // Opsional: Tombol Start jika mau mengaktifkan kembali
                         btnStop = `<button class="btn btn-sm btn-success btn-start-router" data-id="${data.id}" title="Start Router">
                                        <i class="mdi mdi-play"></i>
                                    </button>`;
                    }

                    return `
                        <div class="d-flex gap-1">
                            ${btnOpen}
                            <button class="btn btn-sm btn-warning btn-edit-router" data-id="${data.id}" title="Edit">
                                <i class="mdi mdi-pencil"></i>
                            </button>
                            ${btnStop}
                            <button class="btn btn-sm btn-dark btn-delete-router" data-id="${data.id}" title="Delete">
                                <i class="mdi mdi-trash-can"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // 4. Edit & Reset Logic
    $('#routerTable').on('click', '.btn-edit-router', function() {
        var data = tableRouter.row($(this).parents('tr')).data();
        $('#routerId').val(data.id);
        $('#routerName').val(data.name);
        $('#routerIp').val(data.ip);
        $('#routerPort').val(data.port);
        $('#routerUser').val(data.username);
        $('#routerPass').val(''); 
        $('#formTitle').text('Update Router: ' + data.name);
        $('#btnSubmitRouter').html('<i class="mdi mdi-content-save"></i> Update Router');
        $('#btnResetForm').show();
        $('html, body').animate({ scrollTop: 0 }, 500);
    });

    $('#btnResetForm').on('click', resetForm);

    function resetForm() {
        $('#formRouter')[0].reset();
        $('#routerId').val('');
        $('#formTitle').text('Add New Router');
        $('#btnSubmitRouter').html('<i class="mdi mdi-content-save"></i> Save Router');
        $('#btnResetForm').hide();
    }

    // 5. Stop/Start Logic
    $('#routerTable').on('click', '.btn-stop-router, .btn-start-router', function() {
        var id = $(this).data('id');
        var action = $(this).hasClass('btn-stop-router') ? 'stop' : 'start';
        
        $.ajax({
            url: '../post/toggle_router.php',
            method: 'POST',
            data: { id: id, action: action },
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    showToast(res.message, 'success');
                    tableRouter.ajax.reload();
                } else {
                    showToast(res.message, 'error');
                }
            }
        });
    });

    // 6. Delete Logic
    $('#routerTable').on('click', '.btn-delete-router', function() {
        if(confirm('Are you sure you want to delete this router?')) {
            var id = $(this).data('id');
            $.ajax({
                url: '../post/delete_router.php',
                method: 'POST',
                data: { id: id },
                dataType: 'json',
                success: function(res) {
                    if(res.status === 'success') {
                        showToast(res.message, 'success');
                        tableRouter.ajax.reload();
                        if($('#routerId').val() == id) resetForm();
                    } else {
                        showToast(res.message, 'error');
                    }
                }
            });
        }
    });
});
</script>