<?php
// post/update_settings.php
require_once '../config/config.php';
header('Content-Type: application/json');

// Cek jika request method POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    try {
        // Daftar key yang diizinkan untuk disimpan
        $allowed_keys = [
            'app_name', 
            'company_name', 
            'company_address', 
            'company_phone', 
            'currency', 
            'footer_text',
            'telegram_token',   // Baru
            'telegram_chat_id'  // Baru
        ];
        
        // Prepare statement
        $stmt = $pdo->prepare("INSERT INTO settings (setting_key, setting_value) VALUES (?, ?) 
                               ON DUPLICATE KEY UPDATE setting_value = VALUES(setting_value)");

        $pdo->beginTransaction();

        foreach ($_POST as $key => $value) {
            if (in_array($key, $allowed_keys)) {
                // Tambahkan trim() untuk menghapus spasi di awal/akhir
                $stmt->execute([$key, trim($value)]);
            }
        }

        $pdo->commit();

        echo json_encode([
            'status' => 'success', 
            'message' => $lang[$current_lang]['setting_update_success'] ?? 'Settings updated successfully'
        ]);

    } catch (PDOException $e) {
        $pdo->rollBack();
        echo json_encode([
            'status' => 'error', 
            'message' => 'Database Error: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}