<?php
// post/update_router.php
require_once '../config/config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;
    $name = $_POST['name'] ?? '';
    $ip = $_POST['ip'] ?? '';
    $port = $_POST['port'] ?? 8728;
    $user = $_POST['user'] ?? '';
    $pass = $_POST['pass'] ?? '';

    if (empty($id) || empty($name) || empty($ip)) {
        echo json_encode(['status' => 'error', 'message' => 'Data tidak lengkap']);
        exit;
    }

    try {
        // Jika password diisi, update password. Jika kosong, jangan update password
        if (!empty($pass)) {
            $stmt = $pdo->prepare("UPDATE routers SET name=?, ip=?, port=?, username=?, password=? WHERE id=?");
            $stmt->execute([$name, $ip, $port, $user, $pass, $id]);
        } else {
            $stmt = $pdo->prepare("UPDATE routers SET name=?, ip=?, port=?, username=? WHERE id=?");
            $stmt->execute([$name, $ip, $port, $user, $id]);
        }

        echo json_encode(['status' => 'success', 'message' => 'Router berhasil diupdate']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}
?>