<?php
// post/save_router.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $ip = $_POST['ip'] ?? '';
    $port = $_POST['port'] ?? 8728;
    $user = $_POST['user'] ?? '';
    $pass = $_POST['pass'] ?? '';

    if (empty($name) || empty($ip)) {
        echo json_encode(['status' => 'error', 'message' => 'Name and IP are required']);
        exit;
    }

    try {
        // Insert ke tabel routers (Pastikan tabel ini ada di database)
        $stmt = $pdo->prepare("INSERT INTO routers (name, ip, port, username, password) VALUES (?, ?, ?, ?, ?)");
        $stmt->execute([$name, $ip, $port, $user, $pass]);

        echo json_encode(['status' => 'success', 'message' => 'Router saved successfully']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
    }
}
?>