<?php
// post/edit_user.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $id = $_POST['id'] ?? 0;
 $username = $_POST['username'] ?? '';
 $password = $_POST['password'] ?? '';
 $full_name = $_POST['full_name'] ?? '';
 $email = $_POST['email'] ?? '';
 $location = $_POST['location'] ?? NULL;
 $role = $_POST['role'] ?? 'guest';
 $status = $_POST['status'] ?? 'active';

try {
    // Jika password diisi, update password. Jika tidak, abaikan.
    if (!empty($password)) {
        $hashed_password = password_hash($password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("UPDATE users SET username=?, password=?, full_name=?, email=?, location=?, role=?, status=? WHERE id=?");
        $stmt->execute([$username, $hashed_password, $full_name, $email, $location, $role, $status, $id]);
    } else {
        $stmt = $pdo->prepare("UPDATE users SET username=?, full_name=?, email=?, location=?, role=?, status=? WHERE id=?");
        $stmt->execute([$username, $full_name, $email, $location, $role, $status, $id]);
    }
    
    echo json_encode(['status' => 'success', 'message' => 'User updated successfully']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}