<?php
// post/edit_location.php
require_once '../config/config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $id = $_POST['id'] ?? 0;
 $name = $_POST['name'] ?? '';
 $hotspot_link = $_POST['hotspot_link'] ?? ''; // Ambil data link

if (empty($name)) {
    echo json_encode(['status' => 'error', 'message' => 'Name is required']);
    exit;
}

try {
    // Query diupdate untuk menyertakan hotspot_link
    $stmt = $pdo->prepare("UPDATE locations SET name = ?, hotspot_link = ? WHERE id = ?");
    $stmt->execute([$name, $hotspot_link, $id]);
    
    echo json_encode(['status' => 'success', 'message' => 'Location updated successfully']);
} catch (PDOException $e) {
    if ($e->errorInfo[1] == 1062) {
        echo json_encode(['status' => 'error', 'message' => 'Location name already exists']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error']);
    }
}