<?php
// post/edit_konsumen.php
require_once '../config/config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $id     = $_POST['edit_id'] ?? 0;
 $nama   = $_POST['edit_nama'] ?? '';
 $phone  = $_POST['edit_phone'] ?? '';
 $floor  = $_POST['edit_floor'] ?? '';
 $room   = $_POST['edit_room'] ?? '';

if (empty($id) || empty($nama) || empty($phone)) {
    echo json_encode(['status' => 'error', 'message' => 'Data tidak lengkap']);
    exit;
}

try {
    $stmt = $pdo->prepare("UPDATE konsumen SET nama = ?, phone = ?, floor = ?, room = ? WHERE id = ?");
    $stmt->execute([$nama, $phone, $floor, $room, $id]);

    echo json_encode(['status' => 'success', 'message' => 'Data konsumen berhasil diperbarui']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
}