<?php
// post/delete_router.php
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;

    if (empty($id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid ID']);
        exit;
    }

    try {
        $stmt = $pdo->prepare("DELETE FROM routers WHERE id = ?");
        $stmt->execute([$id]);

        echo json_encode([
            'status' => 'success', 
            'message' => 'Router deleted successfully'
        ]);

    } catch (PDOException $e) {
        echo json_encode([
            'status' => 'error', 
            'message' => 'Database Error: ' . $e->getMessage()
        ]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}
?>