<?php
// post/add_voucher.php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Ambil data dari form
    $code = $_POST['code'];
    $location_id = !empty($_POST['location_id']) ? $_POST['location_id'] : NULL;
    
    // Sesuaikan dengan nama input di form dan database baru
    $nama_paket = $_POST['nama_paket'];       // Input baru
    $durasi_hari = $_POST['durasi_hari'];     // Input baru (menggantikan duration)
    $price = $_POST['price'];
    $tanggal_pembuatan = $_POST['tanggal_pembuatan']; // Input baru (menggantikan expired_at)
    
    // Link tidak lagi diambil dari POST, tapi akan digenerate otomatis
    $link = ''; 
    $status = $_POST['status'] ?? 'active';

    // LOGIKA GENERATE LINK OTOMATIS
    // Jika location_id dipilih, ambil hotspot_link dari tabel locations
    if ($location_id) {
        try {
            $stmt_loc = $pdo->prepare("SELECT hotspot_link FROM locations WHERE id = ?");
            $stmt_loc->execute([$location_id]);
            $location_data = $stmt_loc->fetch(PDO::FETCH_ASSOC);

            if ($location_data && !empty($location_data['hotspot_link'])) {
                // Bersihkan link base (hilangkan slash di akhir jika ada)
                $base_link = rtrim($location_data['hotspot_link'], '/');
                
                // Format link login Mikrotik standard:
                // http://server/login?username=code&password=code
                // Asumsi: password sama dengan username (code) untuk voucher
                $link = $base_link . '/login?username=' . urlencode($code) . '&password=' . urlencode($code);
            }
        } catch (PDOException $e) {
            // Jika gagal ambil data lokasi, link tetap kosong atau bisa di-set default
            $link = '';
        }
    }

    try {
        // Query INSERT disesuaikan dengan kolom baru: nama_paket, durasi_hari, tanggal_pembuatan
        // Variabel $link sekarang berisi link yang sudah digenerate otomatis
        $stmt = $pdo->prepare("INSERT INTO vouchers (code, location_id, nama_paket, durasi_hari, price, tanggal_pembuatan, link, status) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->execute([$code, $location_id, $nama_paket, $durasi_hari, $price, $tanggal_pembuatan, $link, $status]);
        
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['add_success'] ?? 'Voucher berhasil ditambahkan',
            'type' => 'success'
        ];
    } catch (PDOException $e) {
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['add_error'] ?? 'Gagal menambahkan voucher: ' . $e->getMessage(),
            'type' => 'error'
        ];
    }
}

header('Location: ../view/voucher.php');
exit;
?>