<?php
// post/add_konsumen.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validasi Keamanan Lokasi
    $lokasi_input = $_POST['lokasi'] ?? '';
    
    if ($_SESSION['role'] !== 'admin') {
        $lokasi = $_SESSION['location'];
    } else {
        $lokasi = $lokasi_input;
    }

    $phone     = $_POST['phone'] ?? '';
    $nama      = $_POST['nama'] ?? '';
    $floor     = $_POST['floor'] ?? '';
    $room      = $_POST['room'] ?? '';
    $packet    = $_POST['packet'] ?? '';
    $price     = $_POST['price'] ?? 0;
    $durasi    = $_POST['durasi_hari'] ?? 0;
    $tanggal   = $_POST['tanggal'] ?? date('Y-m-d');

    // Cek apakah ada data kosong
    if (empty($phone) || empty($nama) || empty($packet) || empty($lokasi)) {
        $msg_empty = $lang[$current_lang]['no_data'] ?? 'Data tidak lengkap';
        echo json_encode(['status' => 'error', 'message' => $msg_empty]);
        exit;
    }

    try {
        // 1. Cari ID Lokasi dan Ambil Hotspot Link (Untuk Fallback)
        $stmtLoc = $pdo->prepare("SELECT id, hotspot_link FROM locations WHERE name = ?");
        $stmtLoc->execute([$lokasi]);
        $locData = $stmtLoc->fetch(PDO::FETCH_ASSOC);
        $location_id = $locData['id'] ?? 0;
        $base_hotspot_link = $locData['hotspot_link'] ?? '';

        if ($location_id == 0) {
            echo json_encode(['status' => 'error', 'message' => 'Lokasi tidak valid']);
            exit;
        }

        // 2. Cari Voucher
        $stmtVoucher = $pdo->prepare("SELECT * FROM vouchers 
                                      WHERE location_id = ? 
                                      AND nama_paket = ? 
                                      AND price = ? 
                                      AND status = 'active' 
                                      LIMIT 1");
        $stmtVoucher->execute([$location_id, $packet, $price]);
        $voucher = $stmtVoucher->fetch(PDO::FETCH_ASSOC);

        if ($voucher) {
            $pdo->beginTransaction();

            // --- LOGIKA PENANGANAN LINK (FIX UTAMA) ---
            $final_link = $voucher['link']; // Ambil link dari database voucher

            // Jika link kosong di database voucher, buat otomatis dari lokasi
            if (empty($final_link) && !empty($base_hotspot_link)) {
                $clean_base = rtrim($base_hotspot_link, '/');
                $final_link = $clean_base . '/login?username=' . urlencode($voucher['code']) . '&password=' . urlencode($voucher['code']);
            }
            // ------------------------------------------

            // 3. Insert Konsumen
            $stmtK = $pdo->prepare("INSERT INTO konsumen (nama, phone, lokasi, floor, room) VALUES (?, ?, ?, ?, ?)");
            $stmtK->execute([$nama, $phone, $lokasi, $floor, $room]);
            $konsumen_id = $pdo->lastInsertId();

            // 4. Insert Penjualan
            $expire_date = date('Y-m-d', strtotime("+" . $durasi . " days"));
            $dibuat_oleh = $_SESSION['username'] ?? 'System';

            $stmtP = $pdo->prepare("INSERT INTO penjualan_voucher 
                                    (konsumen_id, phone, nama_konsumen, floor, room, packet, durasi_hari, harga, kode_voucher, lokasi, tanggal, expire_date, dibuat_oleh) 
                                    VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            $stmtP->execute([
                $konsumen_id, $phone, $nama, $floor, $room, $packet, $durasi, $price,
                $voucher['code'], $lokasi, $tanggal, $expire_date, $dibuat_oleh
            ]);

            // 5. Update Voucher
            $stmtUpd = $pdo->prepare("UPDATE vouchers SET status = 'used' WHERE id = ?");
            $stmtUpd->execute([$voucher['id']]);

            $pdo->commit();

            // 6. Kirim Notifikasi Telegram (Format Invoice)
            $company_name = $app_setting['app_name'] ?? 'SmartWifi';
            
            // Ambil terjemahan
            $tg_invoice    = $lang[$current_lang]['tg_invoice'] ?? 'INVOICE';
            $tg_from       = $lang[$current_lang]['tg_from'] ?? '!!';
            $tg_to         = $lang[$current_lang]['tg_to'] ?? '!!';
            $tg_company    = $lang[$current_lang]['tg_company'] ?? 'Perusahaan ';
            $tg_admin      = $lang[$current_lang]['tg_admin'] ?? 'Admin';
            
            $tg_con_sec    = $lang[$current_lang]['tg_consumer_section'] ?? 'Detail Konsumen';
            $tg_name       = $lang[$current_lang]['tg_name'] ?? 'Nama';
            $tg_loc        = $lang[$current_lang]['tg_loc'] ?? 'Lokasi';
            $tg_phone      = $lang[$current_lang]['tg_phone'] ?? 'Telepon';
            $tg_floor      = $lang[$current_lang]['tg_floor_label'] ?? 'Floor';
            $tg_room       = $lang[$current_lang]['tg_room_label'] ?? 'Room';
            $tg_wa         = $lang[$current_lang]['tg_wa_label'] ?? 'WA';
            
            $tg_vou_sec    = $lang[$current_lang]['tg_voucher_section'] ?? 'Detail Voucher';
            $tg_voucher    = $lang[$current_lang]['tg_voucher'] ?? 'Kode Voucher';
            $tg_packet     = $lang[$current_lang]['tg_packet'] ?? 'Paket';
            $tg_price      = $lang[$current_lang]['tg_price'] ?? 'Harga';
            $tg_link       = $lang[$current_lang]['tg_link'] ?? 'Link Login';

            // Bangun Pesan Invoice
            $message_text  = "🔔 *{$tg_invoice}*\n\n";
            
            // Bagian Pengirim
            $message_text .= "━━━━━━━━━━━━━━━\n";
            $message_text .= "*{$tg_from}*\n";
            $message_text .= "🏢 {$tg_company}: {$company_name}\n";
            $message_text .= "👤 {$tg_admin}: {$dibuat_oleh}\n";
            $message_text .= "━━━━━━━━━━━━━━━\n\n";

            // Bagian Penerima (Konsumen)
            $message_text .= "*{$tg_to} ({$tg_con_sec})*\n";
            $message_text .= "👤 {$tg_name}: {$nama}\n";
            $message_text .= "📍 {$tg_loc}: {$lokasi}\n";
            $message_text .= "📱 {$tg_wa}: {$phone}\n";
            $message_text .= "🏗 {$tg_floor}: {$floor}\n";
            $message_text .= "🚪 {$tg_room}: {$room}\n\n";

            // Bagian Voucher
            $message_text .= "━━━━━━━━━━━━━━━\n";
            $message_text .= "*{$tg_vou_sec}*\n";
            $message_text .= "🎫 {$tg_voucher}: `".$voucher['code']."`\n";
            $message_text .= "📦 {$tg_packet}: {$packet}\n";
            $message_text .= "💰 {$tg_price}: *SR " . number_format($price) . "*\n";
            $message_text .= "━━━━━━━━━━━━━━━\n\n";
            
            // Link Login (Menggunakan variable final_link)
            $message_text .= "🔗 {$tg_link}: [Click here]({$final_link})";

            // Proses pengiriman via cURL
            $telegram_token = $app_setting['telegram_token'] ?? '';
            $telegram_chat_id = $app_setting['telegram_chat_id'] ?? '';

            if (!empty($telegram_token) && !empty($telegram_chat_id)) {
                $url = "https://api.telegram.org/bot" . $telegram_token . "/sendMessage";
                
                $data = [
                    'chat_id'    => $telegram_chat_id,
                    'text'       => $message_text,
                    'parse_mode' => 'Markdown',
                    'disable_web_page_preview' => true 
                ];

                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, $url);
                curl_setopt($ch, CURLOPT_POST, true);
                curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
                curl_exec($ch);
                curl_close($ch);
            }

            // 7. Return Data untuk Frontend
            $success_msg = $lang[$current_lang]['add_success'] ?? 'Voucher berhasil dijual';
            
            echo json_encode([
                'status' => 'success', 
                'message' => $success_msg,
                'data' => [
                        'company' => $app_setting['company_name'],
                        'location' => $lokasi,
                        'code' => $voucher['code'],
                        'customer' => $nama,
                        'packet' => $packet,
                        'price' => $price,
                        'link' => $final_link, // PERBAIKAN: Menggunakan $final_link, bukan $link
                        'phone' => $phone,
                        'tanggal' => $tanggal,
                        'expire_date' => $expire_date
                    ]
            ]);

        } else {
            $error_msg = $lang[$current_lang]['no_voucher_stock'] ?? 'Stok voucher habis atau tidak cocok';
            echo json_encode(['status' => 'error', 'message' => $error_msg]);
        }
    } catch (PDOException $e) {
        if ($pdo->inTransaction()) {
            $pdo->rollBack();
        }
        echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
    }
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}
?>