<?php
// get/get_packets.php
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit;
}

 $location_name = $_GET['location'] ?? '';

if (empty($location_name)) {
    echo json_encode([]);
    exit;
}

try {
    // Cari ID Lokasi
    $stmtLoc = $pdo->prepare("SELECT id FROM locations WHERE name = ?");
    $stmtLoc->execute([$location_name]);
    $locData = $stmtLoc->fetch(PDO::FETCH_ASSOC);
    $loc_id = $locData['id'] ?? 0;

    if ($loc_id > 0) {
        $stmt = $pdo->prepare("SELECT DISTINCT nama_paket, durasi_hari, price FROM vouchers WHERE location_id = ? AND status = 'active' ORDER BY price ASC");
        $stmt->execute([$loc_id]);
        $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

        $result = [];
        foreach($rows as $r){
            $result[] = [
                'id' => $r['nama_paket'],
                'text' => $r['nama_paket'] . ' - Rp ' . number_format($r['price']),
                'harga' => $r['price'],
                'durasi' => $r['durasi_hari']
            ];
        }
        echo json_encode($result);
    } else {
        echo json_encode([]);
    }

} catch (PDOException $e) {
    echo json_encode([]);
}