<?php
// get/get_non_active_vouchers.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['data' => []]);
    exit;
}

try {
    $stmt = $pdo->query("SELECT v.*, l.name as location_name 
                         FROM vouchers v 
                         LEFT JOIN locations l ON v.location_id = l.id 
                         WHERE v.status != 'active' 
                         ORDER BY v.created_at DESC");
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['data' => $data]);
} catch (PDOException $e) {
    echo json_encode(['data' => []]);
}