<?php
// get/get_detail_penjualan.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    echo json_encode([]);
    exit;
}

 $id = $_GET['id'] ?? 0;
 $phone = $_GET['phone'] ?? '';

try {
    // 1. Query dengan JOIN
    // Kita mengambil data dari penjualan_voucher, JOIN ke vouchers (untuk link), dan JOIN ke locations (untuk base link fallback)
    $sql = "SELECT 
                p.*, 
                v.link as voucher_link, 
                l.hotspot_link as base_location_link 
            FROM penjualan_voucher p
            LEFT JOIN vouchers v ON p.kode_voucher = v.code
            LEFT JOIN locations l ON v.location_id = l.id";

    // Filter berdasarkan ID Konsumen atau Nomor HP
    if (!empty($id)) {
        $sql .= " WHERE p.konsumen_id = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$id]);
    } else if (!empty($phone)) {
        $sql .= " WHERE p.phone = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$phone]);
    } else {
        echo json_encode([]);
        exit;
    }

    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 2. Proses Link untuk setiap baris data
    // Ini menangani kasus dimana link di tabel voucher lama kosong
    foreach ($data as &$row) {
        $final_link = $row['voucher_link']; // Ambil link dari tabel vouchers
        
        // Logika Fallback: Jika link kosong tapi ada base link lokasi, buat link otomatis
        if (empty($final_link) && !empty($row['base_location_link'])) {
            $base = rtrim($row['base_location_link'], '/');
            $code = $row['kode_voucher'];
            $final_link = $base . '/login?username=' . urlencode($code) . '&password=' . urlencode($code);
        }

        // Update/Masukkan key 'link' ke array hasil
        // Frontend mengharapkan key 'link', jadi kita pastikan itu terisi
        $row['link'] = $final_link;
    }

    echo json_encode($data);

} catch (PDOException $e) {
    // Log error jika perlu
    // error_log($e->getMessage());
    echo json_encode([]);
}
?>