<?php
// get/change_theme.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// Ambil tema dari URL
 $theme = $_GET['theme'] ?? 'black';

// Daftar tema yang diizinkan
 $allowed_themes = ['black', 'green', 'blue', 'ungu', 'biru_muda'];

if (in_array($theme, $allowed_themes)) {
    try {
        // 1. Update ke Database
        $stmt = $pdo->prepare("UPDATE users SET theme = ? WHERE id = ?");
        $stmt->execute([$theme, $_SESSION['user_id']]);

        // 2. Update Session (agar langsung berubah tanpa reload)
        $_SESSION['theme'] = $theme;
        
        $_SESSION['flashMessage'] = [
            'text' => 'Theme updated successfully',
            'type' => 'success'
        ];
    } catch (PDOException $e) {
        $_SESSION['flashMessage'] = [
            'text' => 'Failed to update theme',
            'type' => 'error'
        ];
    }
}

// Kembali ke halaman sebelumnya
header('Location: ' . $_SERVER['HTTP_REFERER']);
exit;