<?php
// get/change_lang.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// Ambil kode bahasa dari URL
 $lang_code = $_GET['lang'] ?? 'id';

// Daftar bahasa yang diizinkan
 $allowed_langs = ['id', 'en', 'bn'];

if (in_array($lang_code, $allowed_langs)) {
    try {
        // 1. Update ke Database
        $stmt = $pdo->prepare("UPDATE users SET lang = ? WHERE id = ?");
        $stmt->execute([$lang_code, $_SESSION['user_id']]);

        // 2. Update Session
        $_SESSION['lang'] = $lang_code;
        
        // Tidak perlu flash message untuk bahasa karena perpindahan halaman sudah cukup
    } catch (PDOException $e) {
        // Optional: handle error
    }
}

header('Location: ' . $_SERVER['HTTP_REFERER']);
exit;