<?php
// config/config.php
session_start();

// Database Configuration
define('DB_HOST', 'localhost');
define('DB_NAME', 'temr1846_smartwifi');
define('DB_USER', 'temr1846_dinar_hotspot2026');
define('DB_PASS', 'Maulana1967@');

// Application Version
define('APP_VERSION', '2.0.26');
define('APP_URL', 'http://localhost/spr_2026');

// --- 1. DATABASE CONNECTION (Dipindahkan ke atas) ---
try {
    $pdo = new PDO("mysql:host=" . DB_HOST . ";dbname=" . DB_NAME, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch(PDOException $e) {
    die("Connection failed: " . $e->getMessage());
}

// --- 2. LOAD GLOBAL SETTINGS DARI DATABASE ---
 $app_setting = [];
try {
    $stmt_set = $pdo->query("SELECT setting_key, setting_value FROM settings");
    while($row = $stmt_set->fetch(PDO::FETCH_ASSOC)){
        $app_setting[$row['setting_key']] = $row['setting_value'];
    }
} catch (Exception $e) {
    // Fallback jika tabel settings belum ada
    $app_setting = [];
}

// Define APP_NAME (Diutamakan dari Database)
define('APP_NAME', $app_setting['app_name'] ?? 'SmartWifi');

// Theme Configuration
 $themes = [
    'black' => ['primary' => '#1a1a2e', 'secondary' => '#16213e', 'accent' => '#e94560', 'text' => '#eaeaea'],
    'green' => ['primary' => '#0d2818', 'secondary' => '#1a472a', 'accent' => '#00d26a', 'text' => '#e8f5e9'],
    'blue' => ['primary' => '#0a192f', 'secondary' => '#112240', 'accent' => '#64ffda', 'text' => '#ccd6f6'],
    'ungu' => ['primary' => '#2d132c', 'secondary' => '#4a1942', 'accent' => '#ee6c4d', 'text' => '#f0e6f0'],
    'biru_muda' => ['primary' => '#1b262c', 'secondary' => '#0f4c75', 'accent' => '#3282b8', 'text' => '#bbe1fa']
];

// Size Configuration
 $sizes = [
    'text' => ['xs' => '11px', 's' => '13px', 'm' => '15px', 'l' => '17px'],
    'button' => ['xs' => 'padding: 3px 8px; font-size: 11px;', 's' => 'padding: 5px 12px; font-size: 13px;', 'm' => 'padding: 8px 16px; font-size: 14px;', 'l' => 'padding: 12px 24px; font-size: 16px;'],
    'icon' => ['xs' => '12px', 's' => '14px', 'm' => '18px', 'l' => '24px']
];

// --- LOAD LANGUAGE FILE ---
require_once __DIR__ . '/../includes/lang.php';

// --- 3. SYNC USER PREFERENCES DARI DATABASE KE SESSION ---
// Logika ini memastikan saat user login, setting yang tersimpan di DB dipakai
if (isset($_SESSION['user_id'])) {
    try {
        $stmt_user = $pdo->prepare("SELECT lang, theme, text_size, btn_size, icon_size FROM users WHERE id = ?");
        $stmt_user->execute([$_SESSION['user_id']]);
        $user_prefs = $stmt_user->fetch(PDO::FETCH_ASSOC);

        if ($user_prefs) {
            // Update Session dengan data dari Database
            $_SESSION['lang']       = $user_prefs['lang'] ?? 'id';
            $_SESSION['theme']      = $user_prefs['theme'] ?? 'black';
            $_SESSION['text_size']  = $user_prefs['text_size'] ?? 'm';
            $_SESSION['btn_size']   = $user_prefs['btn_size'] ?? 'm';
            $_SESSION['icon_size']  = $user_prefs['icon_size'] ?? 'm';
        }
    } catch (Exception $e) {
        // Abaikan error jika tabel user belum siap
    }
}

// --- 4. SET CURRENT VARIABLES (Gunakan Session yang sudah di-update) ---
 $current_lang      = $_SESSION['lang'] ?? 'id';
 $current_theme     = $_SESSION['theme'] ?? 'black';
 $current_text_size = $_SESSION['text_size'] ?? 'm';
 $current_btn_size  = $_SESSION['btn_size'] ?? 'm';
 $current_icon_size = $_SESSION['icon_size'] ?? 'm';

// --- FUNGSI AUTO FORMAT INPUT (PROPER CASE) ---
// Fungsi ini akan berjalan jika ada data POST dikirim
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    
    // Daftar field yang TIDAK diubah menjadi Proper Case 
    // (Misal: Password harus asli, Email harus lowercase, Kode Voucher biasanya Uppercase)
    $excluded_fields = ['password', 'pass', 'email', 'username', 'code', 'kode_voucher', 'link'];
    
    // Fungsi untuk mengubah teks menjadi Proper Case
    function make_proper_case($string) {
        // ucwords = Huruf besar di awal kata, strtolower = Huruf kecil sisanya
        return ucwords(strtolower($string));
    }

    // Loop semua data POST
    foreach ($_POST as $key => $value) {
        // Hanya proses jika value adalah string dan bukan field pengecualian
        if (is_string($value) && !in_array($key, $excluded_fields)) {
            $_POST[$key] = make_proper_case($value);
        }
        
        // Khusus Email, paksa menjadi huruf kecil semua
        if ($key === 'email' && is_string($value)) {
            $_POST[$key] = strtolower($value);
        }
    }
}
?>