<?php
// view/voucher.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'voucher'; 
 $pageTitle = $lang[$current_lang]['voucher'];

// Query Data Voucher
 $stmt = $pdo->query("SELECT v.*, l.name as location_name 
                     FROM vouchers v 
                     LEFT JOIN locations l ON v.location_id = l.id 
                     ORDER BY v.created_at DESC");
 $vouchers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// QUERY Lokasi
 $stmt_loc = $pdo->query("SELECT * FROM locations ORDER BY name ASC");
 $locations = $stmt_loc->fetchAll(PDO::FETCH_ASSOC);

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php">Home</a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $lang[$current_lang]['voucher'] ?? 'Voucher' ?></span>
            </nav>
        </div>
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item <?= $current_lang === 'id' ? 'active' : '' ?>" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'en' ? 'active' : '' ?>" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item <?= $current_lang === 'bn' ? 'active' : '' ?>" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-format-size"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><h6 class="dropdown-header">Text Size</h6></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=xs">XS</a></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=m">M</a></li>
                    <li><a class="dropdown-item" href="../get/change_size.php?type=text&size=l">L</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['voucher_list'] ?></h1>
                <p class="page-subtitle"><?= $lang[$current_lang]['manage'] ?? 'Manage wifi vouchers' ?></p>
            </div>
            <div class="d-flex gap-2">
                <a href="../get/template_voucher.php" class="btn btn-secondary">
                    <i class="mdi mdi-download"></i> <?= $lang[$current_lang]['download_template'] ?? 'Download Template' ?>
                </a>
                <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#importModal">
                    <i class="mdi mdi-database-import"></i> <?= $lang[$current_lang]['import_voucher'] ?? 'Import Voucher' ?>
                </button>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addVoucherModal">
                    <i class="mdi mdi-plus"></i> <?= $lang[$current_lang]['add_new'] ?>
                </button>
            </div>
        </div>
        
        <div class="card fade-in">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table data-table" id="voucherTable">
                        <thead>
                            <tr>
                                <th><?= $lang[$current_lang]['voucher_code'] ?></th>
                                <th><?= $lang[$current_lang]['locations'] ?></th>
                                <th>Paket</th>
                                <!-- Durasi Hari Dihapus dari Sini -->
                                <th><?= $lang[$current_lang]['price'] ?></th>
                                <th>Tgl. Pembuatan</th>
                                <th><?= $lang[$current_lang]['link'] ?></th>
                                <th><?= $lang[$current_lang]['status'] ?></th>
                                <th class="text-end"><?= $lang[$current_lang]['action'] ?></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($vouchers as $row): ?>
                            <tr>
                                <td><strong><?= htmlspecialchars($row['code']) ?></strong></td>
                                <td><?= htmlspecialchars($row['location_name'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($row['nama_paket']) ?></td>
                                <!-- Data Durasi Hari Dihapus dari Sini -->
                                <td>SR <?= number_format($row['price']) ?></td>
                                <td>
                                    <?php 
                                    echo !empty($row['tanggal_pembuatan']) ? date('d M Y', strtotime($row['tanggal_pembuatan'])) : '-';
                                    ?>
                                </td>
                                <td>
                                    <button class="btn btn-secondary btn-sm copy-link" data-link="<?= htmlspecialchars($row['link']) ?>">
                                        <i class="mdi mdi-content-copy"></i>
                                    </button>
                                </td>
                                <td>
                                    <?php 
                                        $status_class = 'bg-success';
                                        if($row['status'] == 'used') $status_class = 'bg-warning';
                                        if($row['status'] == 'expired') $status_class = 'bg-danger';
                                    ?>
                                    <span class="badge <?= $status_class ?>">
                                        <?= $lang[$current_lang][$row['status']] ?? $row['status'] ?>
                                    </span>
                                </td>
                                <td>
                                    <div class="d-flex gap-2 justify-content-end">
                                        <a href="#" class="btn btn-sm btn-info"><i class="mdi mdi-eye"></i></a>
                                        <form action="../post/delete_voucher.php" method="POST" class="d-inline" onsubmit="return confirm('Are you sure?')">
                                            <input type="hidden" name="id" value="<?= $row['id'] ?>">
                                            <button type="submit" class="btn btn-sm btn-danger btn-delete">
                                                <i class="mdi mdi-trash-can"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
<!-- Footer -->
<footer class="footer">
    <p>
        <?= htmlspecialchars($app_setting['footer_text'] ?? 'SmartWifi Voucher System v'.APP_VERSION) ?>
    </p>
</footer>
</main>
</div>

<!-- Modal Import -->
<div class="modal fade" id="importModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="../post/import_voucher.php" method="POST" enctype="multipart/form-data">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="mdi mdi-database-import me-2"></i><?= $lang[$current_lang]['import_voucher'] ?? 'Import Voucher' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="csv_file" class="form-label"><?= $lang[$current_lang]['choose_file'] ?? 'Choose CSV File' ?></label>
                        <input type="file" class="form-control" name="csv_file" id="csv_file" accept=".csv" required>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-upload me-1"></i><?= $lang[$current_lang]['import_data'] ?? 'Import' ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Add Voucher -->
<div class="modal fade" id="addVoucherModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <form action="../post/add_voucher.php" method="POST">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="mdi mdi-plus-circle me-2"></i><?= $lang[$current_lang]['add_voucher'] ?? 'Add Voucher' ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['voucher_code'] ?></label>
                        <input type="text" name="code" class="form-control" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['locations'] ?></label>
                        <select name="location_id" class="form-select select2" required>
                            <option value="">-- Pilih Lokasi --</option>
                            <?php foreach ($locations as $loc): ?>
                            <option value="<?= $loc['id'] ?>"><?= htmlspecialchars($loc['name']) ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    
                    <!-- Input Nama Paket -->
                    <div class="mb-3">
                        <label class="form-label">Nama Paket</label>
                        <input type="text" name="nama_paket" class="form-control" placeholder="Contoh: 1 Jam, 1 Hari" required>
                    </div>

                    <!-- Input Durasi Hari (Tetap ada di form untuk disimpan ke DB) -->
                    <div class="mb-3">
                        <label class="form-label">Durasi (Hari)</label>
                        <input type="number" name="durasi_hari" class="form-control" placeholder="Contoh: 1, 3, 7" required>
                    </div>

                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['price'] ?></label>
                        <input type="number" name="price" class="form-control" required>
                    </div>

                    <!-- Input Tanggal Pembuatan -->
                    <div class="mb-3">
                        <label class="form-label">Tanggal Pembuatan</label>
                        <input type="date" name="tanggal_pembuatan" class="form-control" required>
                    </div>

                    <!-- KOLOM LINK DIHAPUS DARI SINI -->

                    <div class="mb-3">
                        <label class="form-label"><?= $lang[$current_lang]['status'] ?></label>
                        <select name="status" class="form-select">
                            <option value="active">Active</option>
                            <option value="used">Used</option>
                            <option value="expired">Expired</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal"><?= $lang[$current_lang]['cancel'] ?></button>
                    <button type="submit" class="btn btn-primary"><i class="mdi mdi-check me-1"></i><?= $lang[$current_lang]['save'] ?></button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script>
 $(document).ready(function() {
    $('.select2').select2({
        width: '100%',
        dropdownParent: $('#addVoucherModal') 
    });

    // PERBAIKAN COPY LINK
    // Kita menggunakan $(document).on('click', ... ) agar event tetap bekerja
    // meskipun tabel di-refresh oleh DataTable (pagination/search).
    $(document).on('click', '.copy-link', function(e) {
        e.preventDefault(); // Mencegah aksi default tombol
        
        // Ambil data link dari atribut data-link
        var link = $(this).data('link');

        // Validasi: Cek apakah link ada isinya
        if (!link || link.trim() === "") {
            // Menggunakan Toast jika tersedia, jika tidak pakai Alert biasa
            if (typeof window.showToast !== 'undefined') {
                window.showToast('Link kosong atau belum tersedia.', 'error');
            } else {
                alert('Link kosong atau belum tersedia.');
            }
            return;
        }

        // Melakukan copy ke clipboard
        navigator.clipboard.writeText(link).then(function() {
            // Jika sukses
            if (typeof window.showToast !== 'undefined') {
                window.showToast('<?= $lang[$current_lang]['copied'] ?? 'Copied!' ?>', 'success');
            } else {
                alert('Link berhasil disalin!');
            }
        }).catch(function(err) {
            // Jika gagal (misal browser tidak mendukung API atau https issue)
            console.error('Gagal menyalin: ', err);
            if (typeof window.showToast !== 'undefined') {
                window.showToast('Gagal menyalin link.', 'error');
            } else {
                alert('Gagal menyalin link.');
            }
        });
    });
});
</script>