<?php
// view/router_dashboard.php
require_once '../config/config.php';
if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// 1. Ambil ID Router dari URL
if (!isset($_GET['id']) || empty($_GET['id'])) {
    header('Location: add_router.php');
    exit;
}

 $router_id = (int)$_GET['id'];

// 2. Ambil Data Kredensial Router dari DB
 $stmt = $pdo->prepare("SELECT * FROM routers WHERE id = ?");
 $stmt->execute([$router_id]);
 $router = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$router) {
    die("Router not found.");
}

 $activePage = 'add_router'; // Biar menu sidebar tetap active
 $pageTitle = 'Router Dashboard: ' . htmlspecialchars($router['name']);

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Tambahkan Chart.js untuk Grafik -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <a href="add_router.php"><?= $lang[$current_lang]['manage_routers'] ?? 'Routers' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= htmlspecialchars($router['name']) ?></span>
            </nav>
        </div>
        <!-- Header Right Standar -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item text-danger" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> Logout</a></li>
                </ul>
            </div>
        </div>
    </header>
    
    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title">Dashboard: <?= htmlspecialchars($router['name']) ?></h1>
                <p class="page-subtitle">Realtime monitoring for <?= htmlspecialchars($router['ip']) ?></p>
            </div>
            <div>
                <a href="http://<?= htmlspecialchars($router['ip']) ?>" target="_blank" class="btn btn-info">
                    <i class="mdi mdi-web"></i> WebFig
                </a>
            </div>
        </div>

        <!-- Stats Cards -->
        <div class="row">
            <!-- CPU Load -->
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="stat-card fade-in">
                    <div class="stat-icon"><i class="mdi mdi-memory"></i></div>
                    <div class="stat-content">
                        <h3 id="cpuLoad">0%</h3>
                        <p>CPU Load</p>
                    </div>
                </div>
            </div>
            <!-- Active Users -->
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="stat-card fade-in">
                    <div class="stat-icon" style="background: linear-gradient(135deg, #00d26a, #0d2818);"><i class="mdi mdi-account-check"></i></div>
                    <div class="stat-content">
                        <h3 id="activeUsers">0</h3>
                        <p>Active Users</p>
                    </div>
                </div>
            </div>
            <!-- Total Users -->
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="stat-card fade-in">
                    <div class="stat-icon" style="background: linear-gradient(135deg, #64ffda, #0a192f);"><i class="mdi mdi-account-group"></i></div>
                    <div class="stat-content">
                        <h3 id="totalUsers">0</h3>
                        <p>Total Users</p>
                    </div>
                </div>
            </div>
            <!-- Expired Today -->
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="stat-card fade-in">
                    <div class="stat-icon" style="background: linear-gradient(135deg, #e94560, #16213e);"><i class="mdi mdi-account-clock"></i></div>
                    <div class="stat-content">
                        <h3 id="expiredToday">0</h3>
                        <p>Expired Today</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="row">
            <!-- Traffic Chart -->
            <div class="col-lg-8 mb-4">
                <div class="card fade-in h-100">
                    <div class="card-header">
                        <h5 class="card-title"><i class="mdi mdi-ethernet me-2"></i> Traffic Monitor (LAN)</h5>
                    </div>
                    <div class="card-body">
                        <canvas id="trafficChart" height="100"></canvas>
                    </div>
                </div>
            </div>

            <!-- System Info -->
            <div class="col-lg-4 mb-4">
                <div class="card fade-in h-100">
                    <div class="card-header">
                        <h5 class="card-title"><i class="mdi mdi-chip me-2"></i> System Info</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group list-group-flush">
                            <li class="list-group-item d-flex justify-content-between"><span>Board Name</span> <strong id="boardName">-</strong></li>
                            <li class="list-group-item d-flex justify-content-between"><span>Model</span> <strong id="boardModel">-</strong></li>
                            <li class="list-group-item d-flex justify-content-between"><span>Uptime</span> <strong id="uptime">-</strong></li>
                            <li class="list-group-item d-flex justify-content-between"><span>RouterOS Ver</span> <strong id="rosVersion">-</strong></li>
                            <li class="list-group-item d-flex justify-content-between"><span>Free Memory</span> <strong id="freeMem">-</strong></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Hotspot Log -->
        <div class="row">
            <div class="col-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h5 class="card-title"><i class="mdi mdi-script-text me-2"></i> Hotspot Log (Last 20)</h5>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover" id="logTable">
                                <thead>
                                    <tr>
                                        <th>Time</th>
                                        <th>Topics</th>
                                        <th>Message</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <!-- Diisi via AJAX -->
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php require_once '../includes/footer.php'; ?>

<script>
 $(document).ready(function() {
    const routerId = <?= $router_id ?>;
    
    // Inisialisasi Chart.js
    const ctx = document.getElementById('trafficChart').getContext('2d');
    const trafficChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: [], // Waktu
            datasets: [
                {
                    label: 'Download (RX)',
                    data: [],
                    borderColor: '#00d26a',
                    backgroundColor: 'rgba(0, 210, 106, 0.2)',
                    tension: 0.4,
                    fill: true
                },
                {
                    label: 'Upload (TX)',
                    data: [],
                    borderColor: '#64ffda',
                    backgroundColor: 'rgba(100, 255, 218, 0.2)',
                    tension: 0.4,
                    fill: true
                }
            ]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: { color: '#8892b0' },
                    grid: { color: 'rgba(255,255,255,0.05)' }
                },
                x: {
                    ticks: { color: '#8892b0' },
                    grid: { display: false }
                }
            },
            plugins: {
                legend: { labels: { color: '#eaeaea' } }
            }
        }
    });

    // Fungsi Fetch Data
    function fetchRouterStats() {
        $.ajax({
            url: '../get/get_router_stats.php',
            method: 'GET',
            data: { id: routerId },
            dataType: 'json',
            success: function(res) {
                if(res.status === 'success') {
                    const data = res.data;
                    
                    // Update Stats
                    $('#cpuLoad').text(data.cpu_load + '%');
                    $('#activeUsers').text(data.active_users);
                    $('#totalUsers').text(data.total_users);
                    $('#expiredToday').text(data.expired_today);
                    
                    // Update System Info
                    $('#boardName').text(data.board_name);
                    $('#boardModel').text(data.model);
                    $('#uptime').text(data.uptime);
                    $('#rosVersion').text(data.version);
                    $('#freeMem').text(data.free_memory);
                    
                    // Update Traffic Chart (Push Data)
                    const now = new Date().toLocaleTimeString();
                    if (trafficChart.data.labels.length > 20) {
                        trafficChart.data.labels.shift();
                        trafficChart.data.datasets[0].data.shift();
                        trafficChart.data.datasets[1].data.shift();
                    }
                    
                    // Asumsi traffic dalam Kbps atau Mbps, konversi ke angka saja
                    trafficChart.data.labels.push(now);
                    // RX (Download) - ambil nilai numerik
                    trafficChart.data.datasets[0].data.push(data.rx_speed);
                    // TX (Upload)
                    trafficChart.data.datasets[1].data.push(data.tx_speed);
                    
                    trafficChart.update();

                    // Update Logs
                    const logBody = $('#logTable tbody');
                    logBody.empty();
                    if(data.logs.length > 0) {
                        data.logs.forEach(log => {
                            logBody.append(`
                                <tr>
                                    <td><small>${log.time}</small></td>
                                    <td><span class="badge bg-secondary">${log.topics}</span></td>
                                    <td>${log.message}</td>
                                </tr>
                            `);
                        });
                    } else {
                        logBody.append('<tr><td colspan="3" class="text-center">No logs found</td></tr>');
                    }

                } else {
                    console.error('API Error:', res.message);
                    // Jika error koneksi, hentikan interval atau tampilkan pesan
                }
            },
            error: function() {
                console.error('Failed to fetch router stats');
            }
        });
    }

    // Panggil pertama kali
    fetchRouterStats();
    
    // Set interval setiap 5 detik
    setInterval(fetchRouterStats, 5000);
});
</script>