<?php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

 $activePage = 'konsumen';
 $pageTitle = $lang[$current_lang]['consumer'] ?? 'Consumer';

 $user_role = $_SESSION['role'];
 $user_location = $_SESSION['location'] ?? '';
 $can_select_location = ($user_role === 'admin');

 $locations_list = [];
if ($can_select_location) {
    $stmtLocList = $pdo->query("SELECT id, name FROM locations ORDER BY name ASC");
    $locations_list = $stmtLocList->fetchAll(PDO::FETCH_ASSOC);
}

 $packet_list = [];
if (!$can_select_location && !empty($user_location)) {
    $stmtLocId = $pdo->prepare("SELECT id FROM locations WHERE name = ?");
    $stmtLocId->execute([$user_location]);
    $locData = $stmtLocId->fetch(PDO::FETCH_ASSOC);
    $loc_id = $locData['id'] ?? 0;

    $stmtPackets = $pdo->prepare("SELECT DISTINCT nama_paket, durasi_hari, price FROM vouchers WHERE location_id = ? AND status = 'active' ORDER BY price ASC");
    $stmtPackets->execute([$loc_id]);
    $packet_list = $stmtPackets->fetchAll(PDO::FETCH_ASSOC);
}

require_once '../includes/header.php';
require_once '../includes/sidebar.php';
?>

<!-- Custom Style -->
<style>
    .form-control, .form-select {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border: 1px solid var(--primary) !important;
    }
    .form-select option { background-color: var(--secondary); color: var(--text); }
    .form-control:focus, .form-select:focus {
        background-color: var(--secondary) !important;
        color: var(--text) !important;
        border-color: var(--accent) !important;
        box-shadow: 0 0 0 0.1rem var(--accent) !important;
    }
    .form-control::placeholder { color: var(--text); opacity: 0.5; }
    .header-right .dropdown-menu { z-index: 1050; }
    
    input::-webkit-outer-spin-button,
    input::-webkit-inner-spin-button {
        -webkit-appearance: none;
        margin: 0;
    }
    input[type=number] {
        -moz-appearance: textfield;
    }
</style>

<!-- Main Content -->
<main class="main-content">
    <!-- Header -->
    <header class="header">
        <div class="header-left">
            <button class="sidebar-toggle" id="sidebarToggle"><i class="mdi mdi-menu"></i></button>
            <nav class="breadcrumb">
                <a href="dashboard.php"><?= $lang[$current_lang]['home'] ?? 'Home' ?></a>
                <i class="mdi mdi-chevron-right"></i>
                <span><?= $pageTitle ?></span>
            </nav>
        </div>
        
        <!-- Header Right -->
        <div class="header-right">
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-translate"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=id">Indonesia</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=en">English</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_lang.php?lang=bn">বাংলা</a></li>
                </ul>
            </div>
             <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-palette"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=black"><span class="theme-dot" style="background:#e94560"></span> Black</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=green"><span class="theme-dot" style="background:#00d26a"></span> Green</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=blue"><span class="theme-dot" style="background:#64ffda"></span> Blue</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=ungu"><span class="theme-dot" style="background:#ee6c4d"></span> Ungu</a></li>
                    <li><a class="dropdown-item" style="color: var(--text);" href="../get/change_theme.php?theme=biru_muda"><span class="theme-dot" style="background:#3282b8"></span> Biru Muda</a></li>
                </ul>
            </div>
            <div class="dropdown">
                <button class="header-btn" data-bs-toggle="dropdown"><i class="mdi mdi-account"></i></button>
                <ul class="dropdown-menu dropdown-menu-end" style="background-color: var(--secondary); border: 1px solid var(--primary);">
                    <li><a class="dropdown-item" style="color: var(--text);" href="profile.php"><i class="mdi mdi-account-outline me-2"></i> Profile</a></li>
                    <li><hr class="dropdown-divider" style="border-color: var(--primary);"></li>
                    <li><a class="dropdown-item text-danger" style="color: #e94560 !important;" href="../get/logout.php"><i class="mdi mdi-logout me-2"></i> <?= $lang[$current_lang]['logout'] ?></a></li>
                </ul>
            </div>
        </div>
    </header>

    <!-- Page Content -->
    <div class="page-content">
        <div class="page-header fade-in">
            <div>
                <h1 class="page-title"><?= $lang[$current_lang]['consumer'] ?? 'Consumer' ?></h1>
                <p class="page-subtitle">
                    <?= $lang[$current_lang]['manage'] ?? 'Manage' ?> - 
                    <?= $lang[$current_lang]['location'] ?? 'Location' ?>: 
                    <strong>
                        <?php if($can_select_location): ?>
                            <span class="text-info">All Locations (Admin)</span>
                        <?php else: ?>
                            <?= htmlspecialchars($user_location) ?>
                        <?php endif; ?>
                    </strong>
                </p>
            </div>
        </div>

        <div class="row">
            <!-- CARD KIRI: Form Konsumen -->
            <div class="col-lg-5 col-md-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-account-plus me-2"></i>
                            <span id="formTitle"><?= $lang[$current_lang]['new_consumer'] ?? 'New Consumer' ?></span>
                        </h3>
                    </div>
                    <div class="card-body">
                        <form id="formKonsumen">
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['phone_wa'] ?? 'Phone' ?></label>
                                <input type="text" name="phone" id="phone" class="form-control" placeholder="96655828xxx if saudi" pattern="[0-9]*" inputmode="numeric" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['name'] ?? 'Name' ?></label>
                                <input type="text" name="nama" id="nama" class="form-control" required>
                            </div>
                            
                            <?php if($can_select_location): ?>
                                <div class="mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['location'] ?? 'Location' ?></label>
                                    <select name="lokasi" id="selectLokasi" class="form-select select2" required>
                                        <option value="">-- Pilih Lokasi --</option>
                                        <?php foreach($locations_list as $loc): ?>
                                        <option value="<?= htmlspecialchars($loc['name']) ?>" data-id="<?= $loc['id'] ?>">
                                            <?= htmlspecialchars($loc['name']) ?>
                                        </option>
                                        <?php endforeach; ?>
                                    </select>
                                </div>
                            <?php else: ?>
                                <input type="hidden" name="lokasi" value="<?= htmlspecialchars($user_location) ?>">
                            <?php endif; ?>

                            <div class="row">
                                <div class="col-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['floor'] ?? 'Floor' ?></label>
                                    <input type="number" name="floor" id="floor" class="form-control">
                                </div>
                                <div class="col-6 mb-3">
                                    <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['room'] ?? 'Room' ?></label>
                                    <input type="number" name="room" id="room" class="form-control">
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['packet'] ?? 'Packet' ?></label>
                                <select name="packet" id="selectPacket" class="form-select select2" required>
                                    <option value="">-- <?= $lang[$current_lang]['select_packet'] ?? 'Select Packet' ?> --</option>
                                    <?php if(!$can_select_location): ?>
                                        <?php foreach($packet_list as $p): ?>
                                        <option value="<?= htmlspecialchars($p['nama_paket']) ?>" 
                                                data-harga="<?= $p['price'] ?>" 
                                                data-durasi="<?= $p['durasi_hari'] ?>">
                                            <?= htmlspecialchars($p['nama_paket']) ?> - Rp <?= number_format($p['price']) ?>
                                        </option>
                                        <?php endforeach; ?>
                                    <?php endif; ?>
                                </select>
                                <?php if(!$can_select_location && empty($packet_list)): ?>
                                    <small class="text-danger mt-2 d-block"><?= $lang[$current_lang]['no_voucher_stock'] ?? 'No voucher stock' ?></small>
                                <?php endif; ?>
                            </div>

                            <div class="mb-3">
                                <label class="form-label" style="color: var(--text)"><?= $lang[$current_lang]['price'] ?? 'Price' ?></label>
                                <input type="text" name="harga_display" id="hargaDisplay" class="form-control" readonly>
                                <input type="hidden" name="price" id="priceHidden">
                                <input type="hidden" name="durasi_hari" id="durasiHidden">
                            </div>

                            <input type="hidden" name="tanggal" value="<?= date('Y-m-d') ?>">
                            
                            <button type="submit" class="btn btn-primary w-100 mt-3" id="btnSubmit">
                                <i class="mdi mdi-content-save me-1"></i> 
                                <?= $lang[$current_lang]['save_sales'] ?? 'Save' ?>
                            </button>
                        </form>
                    </div>
                </div>
            </div>

            <!-- CARD KANAN: Daftar Konsumen -->
            <div class="col-lg-7 col-md-12">
                <div class="card fade-in">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="mdi mdi-account-group me-2"></i>
                            <?= $lang[$current_lang]['consumer_list'] ?? 'Consumer List' ?>
                        </h3>
                    </div>
                    <div class="card-body">
                        <table class="table table-hover" id="tableKonsumen">
                            <thead>
                                <tr>
                                    <th><?= $lang[$current_lang]['name'] ?? 'Name' ?></th>
                                    <th><?= $lang[$current_lang]['floor'] ?? 'Floor' ?></th>
                                    <th><?= $lang[$current_lang]['room'] ?? 'Room' ?></th>
                                    <th><?= $lang[$current_lang]['phone_wa'] ?? 'Phone' ?></th>
                                    <?php if($can_select_location): ?>
                                    <th><?= $lang[$current_lang]['location'] ?? 'Location' ?></th>
                                    <?php endif; ?>
                                    <th style="width: 130px;"><?= $lang[$current_lang]['action'] ?? 'Action' ?></th>
                                </tr>
                            </thead>
                            <tbody>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <footer class="footer">
        <p>
            <?= htmlspecialchars($app_setting['footer_text'] ?? 'SmartWifi Voucher System v'.APP_VERSION) ?>
        </p>
    </footer>
</main>
</div>

<!-- Modal Popup Voucher -->
<div class="modal fade" id="voucherSuccessModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-check-circle text-success me-2"></i><?= $lang[$current_lang]['transaction_successful'] ?? 'Transaction Successful' ?></h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
            </div>
            <div class="modal-body text-center" id="modalContentWrapper">
                <div id="captureArea" style="padding: 20px; background-color: var(--secondary); color: var(--text);">
                    <h4 id="modalCompany" class="mb-1"></h4>
                    <p id="modalLocation" class="text-muted mb-3"></p>
                    <div style="background: var(--primary); padding: 15px; border-radius: 10px; margin-bottom: 15px;">
                        <h2 id="modalCode" style="color: var(--accent); margin:0; font-weight:bold; letter-spacing: 2px;"></h2>
                    </div>
                    <div id="qrcodeContainer" style="display: inline-block; padding: 10px; background: white; border-radius: 8px; margin-bottom: 15px;"></div>
                    <table class="table table-borderless table-sm text-start" style="color: var(--text);">
                        <tr><td width="40%"><?= $lang[$current_lang]['consumer_label'] ?? 'Consumer' ?></td><td>: <strong id="modalCustomer"></strong></td></tr>
                        <tr><td><?= $lang[$current_lang]['packet_label'] ?? 'Packet' ?></td><td>: <strong id="modalPacket"></strong></td></tr>
                        <tr><td><?= $lang[$current_lang]['price_label'] ?? 'Price' ?></td><td>: <strong id="modalPrice"></strong></td></tr>
                        <tr><td><?= $lang[$current_lang]['link_label'] ?? 'Login Link' ?></td><td>: <small id="modalLink" style="word-break: break-all;"></small></td></tr>
                    </table>
                </div>
            </div>
            <div class="modal-footer d-block" style="border-top: 1px solid var(--primary);">
                <div class="row g-2">
                    <div class="col-6">
                        <button type="button" id="btnDownloadImg" class="btn btn-info w-100">
                            <i class="mdi mdi-download"></i> <?= $lang[$current_lang]['download_jpg'] ?? 'Download JPG' ?>
                        </button>
                    </div>
                    <div class="col-6">
                        <button type="button" id="btnShareWa" class="btn btn-success w-100">
                            <i class="mdi mdi-whatsapp"></i> <?= $lang[$current_lang]['share_whatsapp'] ?? 'Share WhatsApp' ?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Edit Konsumen -->
<div class="modal fade" id="editKonsumenModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-account-edit me-2"></i>Edit Konsumen</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
            </div>
            <div class="modal-body">
                <form id="formEditKonsumen">
                    <input type="hidden" name="edit_id" id="edit_id">
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--text);">Nama</label>
                        <input type="text" name="edit_nama" id="edit_nama" class="form-control" required>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label" style="color: var(--text);">No. HP / WhatsApp</label>
                        <input type="text" name="edit_phone" id="edit_phone" class="form-control" pattern="[0-9]*" inputmode="numeric" required>
                    </div>

                    <div class="row">
                        <div class="col-6 mb-3">
                            <label class="form-label" style="color: var(--text);">Lantai</label>
                            <input type="number" name="edit_floor" id="edit_floor" class="form-control">
                        </div>
                        <div class="col-6 mb-3">
                            <label class="form-label" style="color: var(--text);">Kamar</label>
                            <input type="number" name="edit_room" id="edit_room" class="form-control">
                        </div>
                    </div>

                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary flex-grow-1">
                            <i class="mdi mdi-content-save me-1"></i> Simpan
                        </button>
                        <button type="button" id="btnEditWa" class="btn btn-success">
                            <i class="mdi mdi-whatsapp"></i>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal Detail Penjualan -->
<div class="modal fade" id="detailModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-lg">
        <div class="modal-content" style="background-color: var(--secondary); border: 1px solid var(--primary);">
            <div class="modal-header" style="border-bottom: 1px solid var(--primary);">
                <h5 class="modal-title" style="color: var(--text);"><i class="mdi mdi-history me-2"></i>Riwayat Pembelian</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" style="filter: invert(1);"></button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-striped" style="color: var(--text);">
                        <thead>
                            <tr>
                                <th>Tanggal</th>
                                <th>Kode</th>
                                <th>Paket</th>
                                <th>Harga</th>
                                <th>Expire</th>
                            </tr>
                        </thead>
                        <tbody id="detailBody">
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php 
require_once '../includes/footer.php'; 
?>

<script src="https://cdnjs.cloudflare.com/ajax/libs/qrcodejs/1.0.0/qrcode.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2canvas/1.4.1/html2canvas.min.js"></script>

<script>
 $(document).ready(function() {
    // Init Select2
    $('.select2').select2({ width: '100%' });

    const lang_wa_title = "<?= $lang[$current_lang]['wa_msg_title'] ?? 'Voucher Wifi' ?>";
    const lang_wa_loc   = "<?= $lang[$current_lang]['wa_msg_loc'] ?? 'Location' ?>";
    const lang_wa_link  = "<?= $lang[$current_lang]['wa_msg_link'] ?? 'Link' ?>";
    const lang_wa_thanks= "<?= $lang[$current_lang]['wa_msg_thanks'] ?? 'Thank you' ?>";

    // 1. Logic Admin Location
    $('#selectLokasi').on('select2:select', function (e) {
        var loc_name = $(this).val();
        $('#selectPacket').empty().append('<option value="">Loading...</option>').trigger('change');
        $.ajax({
            url: '../get/get_packets.php',
            method: 'GET',
            data: { location: loc_name },
            dataType: 'json',
            success: function(data) {
                $('#selectPacket').empty().append('<option value="">-- Pilih Paket --</option>');
                if(data.length > 0){
                    $.each(data, function(key, val) {
                        var newOption = new Option(val.text, val.id, false, false);
                        $(newOption).data('harga', val.harga);
                        $(newOption).data('durasi', val.durasi);
                        $('#selectPacket').append(newOption);
                    });
                } else {
                    $('#selectPacket').append('<option value="">Tidak ada stok</option>');
                }
                $('#selectPacket').trigger('change');
            }
        });
    });

    // 2. Select Packet Listener
    $('#selectPacket').on('select2:select', function (e) {
        var selected = $(this).find(':selected');
        var harga = selected.data('harga');
        var durasi = selected.data('durasi');
        
        if(harga) {
            $('#hargaDisplay').val('Rp ' + parseFloat(harga).toLocaleString('id-ID'));
            $('#priceHidden').val(harga);
            $('#durasiHidden').val(durasi);
        } else {
            $('#hargaDisplay').val('');
            $('#priceHidden').val('');
            $('#durasiHidden').val('');
        }
    });

    // 3. DataTable
    var tableKonsumen = $('#tableKonsumen').DataTable({
        retrieve: true,
        processing: true,
        language: { search: "", searchPlaceholder: "Cari..." },
        ajax: { url: '../get/get_konsumen.php', type: 'GET', dataSrc: 'data' },
        columns: [
            { data: 'nama' },
            { data: 'floor' },
            { data: 'room' },
            { data: 'phone' },
            <?php if($can_select_location): ?>
            { data: 'lokasi' },
            <?php endif; ?>
            { 
                data: null, 
                render: function(data, type, row) {
                    return `
                        <div class="d-flex gap-1">
                            <button class="btn btn-success btn-sm btn-pilih" title="Pilih"
                                    data-nama="${row.nama}" data-phone="${row.phone}" 
                                    data-floor="${row.floor}" data-room="${row.room}" data-lokasi="${row.lokasi}">
                                <i class="mdi mdi-check"></i>
                            </button>
                            <button class="btn btn-warning btn-sm btn-edit" title="Edit"
                                    data-id="${row.id}" data-nama="${row.nama}" data-phone="${row.phone}" 
                                    data-floor="${row.floor}" data-room="${row.room}">
                                <i class="mdi mdi-pencil"></i>
                            </button>
                            <button class="btn btn-info btn-sm btn-detail" title="Detail" data-id="${row.id}" data-phone="${row.phone}">
                                <i class="mdi mdi-eye"></i>
                            </button>
                        </div>
                    `;
                }
            }
        ]
    });

    // 4. Tombol Pilih
    $('#tableKonsumen').on('click', '.btn-pilih', function() {
        $('#nama').val($(this).data('nama'));
        $('#phone').val($(this).data('phone'));
        $('#floor').val($(this).data('floor'));
        $('#room').val($(this).data('room'));

        <?php if($can_select_location): ?>
        var lokasi = $(this).data('lokasi');
        if(lokasi){
            $('#selectLokasi').val(lokasi).trigger('change.select2'); 
            $('#selectLokasi').trigger('change'); 
        }
        <?php endif; ?>

        $('html, body').animate({ scrollTop: $("#formKonsumen").offset().top - 100 }, 500);
        $('#selectPacket').focus();
    });

    // 5. Tombol Edit
    $('#tableKonsumen').on('click', '.btn-edit', function() {
        var id = $(this).data('id');
        var nama = $(this).data('nama');
        var phone = $(this).data('phone');
        var floor = $(this).data('floor');
        var room = $(this).data('room');

        $('#edit_id').val(id);
        $('#edit_nama').val(nama);
        $('#edit_phone').val(phone);
        $('#edit_floor').val(floor);
        $('#edit_room').val(room);

        $('#editKonsumenModal').modal('show');
    });

    // 6. Submit Form Edit
    $('#formEditKonsumen').on('submit', function(e) {
        e.preventDefault();
        var formData = $(this).serialize();

        $.ajax({
            url: '../post/edit_konsumen.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if(response.status === 'success') {
                    showToast(response.message, 'success');
                    $('#editKonsumenModal').modal('hide');
                    tableKonsumen.ajax.reload();
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // 7. Tombol WA di Modal Edit (PERBAIKAN: BOLD & REDIRECT)
    $('#btnEditWa').on('click', function() {
        var phone = $('#edit_phone').val();
        var konsumen_id = $('#edit_id').val();
        var nama_konsumen = $('#edit_nama').val();
        var btn = $(this);
        
        var company = "<?= htmlspecialchars($app_setting['company_name'] ?? 'SmartWifi') ?>";

        if(!phone) {
            showToast('Nomor HP kosong', 'error');
            return;
        }

        phone = phone.replace(/\D/g, '');

        btn.prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i>');

        $.ajax({
            url: '../get/get_detail_penjualan.php',
            method: 'GET',
            data: { id: konsumen_id },
            dataType: 'json',
            success: function(response) {
                btn.prop('disabled', false).html('<i class="mdi mdi-whatsapp"></i>');
                var wa_text = "";
                
                if(response.length > 0) {
                    var lastSale = response[0];
                    // PERUBAHAN: Menambahkan * untuk BOLD pada Voucher Code
                    wa_text = `*${lang_wa_title} ${company}*\nDate: ${lastSale.tanggal}\n${lang_wa_loc}: ${lastSale.lokasi}\n*Voucher Code: ${lastSale.kode_voucher}*\nPacket: ${lastSale.packet}\nExpired Date: ${lastSale.expire_date}\n${lang_wa_link}: ${lastSale.link ? lastSale.link : '-'}\n\n_${lang_wa_thanks}_`;
                } else {
                    wa_text = `Hai ${nama_konsumen}, ini dari ${company}.`;
                }

                var url = `https://wa.me/${phone}?text=${encodeURIComponent(wa_text)}`;
                window.location.href = url;
            },
            error: function() {
                btn.prop('disabled', false).html('<i class="mdi mdi-whatsapp"></i>');
                var url = `https://wa.me/${phone}?text=${encodeURIComponent('Hai ' + nama_konsumen)}`;
                window.location.href = url;
            }
        });
    });

    // 8. Tombol Detail
    $('#tableKonsumen').on('click', '.btn-detail', function() {
        var id = $(this).data('id');
        var phone = $(this).data('phone');
        
        $('#detailBody').html('<tr><td colspan="5" class="text-center">Memuat data...</td></tr>');
        $('#detailModal').modal('show');

        $.ajax({
            url: '../get/get_detail_penjualan.php',
            method: 'GET',
            data: { id: id, phone: phone },
            dataType: 'json',
            success: function(response) {
                var rows = '';
                if(response.length > 0){
                    $.each(response, function(i, val) {
                        rows += `
                            <tr>
                                <td>${val.tanggal}</td>
                                <td><span class="badge bg-primary">${val.kode_voucher}</span></td>
                                <td>${val.packet}</td>
                                <td>Rp ${parseFloat(val.harga).toLocaleString('id-ID')}</td>
                                <td>${val.expire_date}</td>
                            </tr>
                        `;
                    });
                } else {
                    rows = '<tr><td colspan="5" class="text-center text-muted">Tidak ada riwayat pembelian</td></tr>';
                }
                $('#detailBody').html(rows);
            }
        });
    });

    // 9. Submit Form Baru (PERBAIKAN: BOLD & REDIRECT)
    $('#formKonsumen').on('submit', function(e) {
        e.preventDefault();
        
        <?php if($can_select_location): ?>
        if(!$('#selectLokasi').val()){
            showToast('Pilih lokasi terlebih dahulu', 'error');
            return;
        }
        <?php endif; ?>

        var formData = $(this).serialize();
        var btn = $('#btnSubmit');
        btn.prop('disabled', true).html('<i class="mdi mdi-loading mdi-spin"></i> Proses...');

        $.ajax({
            url: '../post/add_konsumen.php',
            method: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                btn.prop('disabled', false).html('<i class="mdi mdi-content-save me-1"></i> Simpan');
                if(response.status === 'success') {
                    $('#formKonsumen')[0].reset();
                    $('#hargaDisplay').val('');
                    $('#selectPacket').val('').trigger('change'); 
                    <?php if($can_select_location): ?>
                    $('#selectLokasi').val('').trigger('change');
                    <?php endif; ?>
                    tableKonsumen.ajax.reload(); 

                    var data = response.data;
                    $('#modalCompany').text(data.company);
                    $('#modalLocation').text(data.location);
                    $('#modalCode').text(data.code);
                    $('#modalCustomer').text(data.customer);
                    $('#modalPacket').text(data.packet + ' (' + data.price + ')');
                    $('#modalPrice').text('Rp ' + parseInt(data.price).toLocaleString('id-ID'));
                    $('#modalLink').text(data.link);

                    $('#qrcodeContainer').empty();
                    new QRCode(document.getElementById("qrcodeContainer"), {
                        text: data.link, width: 128, height: 128
                    });

                    // PERUBAHAN: Menambahkan * untuk BOLD pada Voucher Code
                    var wa_text = `*${lang_wa_title} ${data.company}*\nDate: ${data.tanggal}\n${lang_wa_loc}: ${data.location}\nVoucher Code: ${data.code}\nPacket: ${data.packet}\nExpired Date: ${data.expire_date}\n${lang_wa_link}: ${data.link}\n\n_${lang_wa_thanks}_`;
                    
                    $('#btnShareWa').data('phone', data.phone);
                    $('#btnShareWa').data('text', wa_text);

                    $('#voucherSuccessModal').modal('show');
                } else {
                    showToast(response.message, 'error');
                }
            }
        });
    });

    // 10. Share WhatsApp (Success Modal)
    $('#btnShareWa').on('click', function() {
        var phone = $(this).data('phone');
        var text = $(this).data('text');
        
        phone = phone.replace(/\D/g, '');
        var url = `https://wa.me/${phone}?text=${encodeURIComponent(text)}`;
        window.location.href = url; 
    });

    // 11. Download Image
    $('#btnDownloadImg').on('click', function() {
        html2canvas(document.querySelector("#captureArea")).then(canvas => {
            var link = document.createElement('a');
            link.download = 'voucher.jpg';
            link.href = canvas.toDataURL();
            link.click();
        });
    });
});
</script>