<?php
// post/toggle_router.php
require_once '../config/config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = $_POST['id'] ?? 0;
    $action = $_POST['action'] ?? ''; // 'start' or 'stop'

    if (empty($id)) {
        echo json_encode(['status' => 'error', 'message' => 'Invalid ID']);
        exit;
    }

    $newStatus = ($action === 'start') ? 'active' : 'inactive';

    try {
        $stmt = $pdo->prepare("UPDATE routers SET status = ? WHERE id = ?");
        $stmt->execute([$newStatus, $id]);

        echo json_encode(['status' => 'success', 'message' => 'Router status updated']);
    } catch (PDOException $e) {
        echo json_encode(['status' => 'error', 'message' => 'Database Error']);
    }
}
?>