<?php
// post/test_telegram.php
require_once '../config/config.php';
header('Content-Type: application/json');

// Kunci akses hanya untuk Admin
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $token = $app_setting['telegram_token'] ?? '';
 $chat_id = $app_setting['telegram_chat_id'] ?? '';

if (empty($token) || empty($chat_id)) {
    echo json_encode(['status' => 'error', 'message' => 'Token atau Chat ID kosong di Settings.']);
    exit;
}

 $message = "🔔 *TEST NOTIFIKASI*\n\nSistem SmartWifi berhasil terhubung ke Telegram Bot ini.\n\n_Timestamp:_ " . date('Y-m-d H:i:s');

 $url = "https://api.telegram.org/bot" . $token . "/sendMessage";

 $ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $url);
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, [
    'chat_id' => $chat_id,
    'text' => $message,
    'parse_mode' => 'Markdown'
]);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

 $result = curl_exec($ch);
 $http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code == 200) {
    echo json_encode(['status' => 'success', 'message' => 'Pesan test berhasil dikirim!']);
} else {
    echo json_encode(['status' => 'error', 'message' => "Gagal. Kode: $http_code. Response: " . $result]);
}