<?php
// post/test_router_connection.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $ip = $_POST['ip'] ?? '';
    $port = $_POST['port'] ?? 8728;
    // Kita tidak butuh user/pass untuk cek koneksi port saja, 
    // tapi jika butuh validasi login, perlu library API.
    // Untuk sekarang kita cek koneksi socket saja.
    
    if (empty($ip) || empty($port)) {
        echo json_encode(['status' => 'error', 'message' => 'IP dan Port wajib diisi']);
        exit;
    }

    $timeout = 5; 
    $connection = @fsockopen($ip, $port, $errno, $errstr, $timeout);
    
    $newStatus = 'disconnected';
    $msg = '';

    if ($connection) {
        fclose($connection);
        $newStatus = 'connected';
        $msg = "Connection Successful! Port $port is open.";
    } else {
        $msg = "Connection Failed. $errstr (Error $errno)";
    }

    // UPDATE DATABASE STATUS CONNECTIVITY
    // Kita cari router berdasarkan IP, lalu update status koneksinya
    try {
        $stmt = $pdo->prepare("UPDATE routers SET connectivity = ? WHERE ip = ?");
        $stmt->execute([$newStatus, $ip]);
    } catch (PDOException $e) {
        // Jika gagal update DB, tidak masalah, yg penting hasil tes muncul
    }

    echo json_encode([
        'status' => ($newStatus === 'connected') ? 'success' : 'error', 
        'message' => $msg
    ]);
} else {
    echo json_encode(['status' => 'error', 'message' => 'Invalid Request']);
}
?>