<?php
// post/reset_status_voucher.php
require_once '../config/config.php';
header('Content-Type: application/json');

if ($_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $ids = $_POST['ids'] ?? [];

if (empty($ids)) {
    echo json_encode(['status' => 'error', 'message' => 'No IDs selected']);
    exit;
}

try {
    // Buat placeholder untuk IN clause (?,?,?)
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    
    $stmt = $pdo->prepare("UPDATE vouchers SET status = 'active' WHERE id IN ($placeholders)");
    $stmt->execute($ids);

    echo json_encode(['status' => 'success', 'message' => count($ids) . ' vouchers reset to Active']);
} catch (PDOException $e) {
    echo json_encode(['status' => 'error', 'message' => 'Database error']);
}