<?php
// post/import_voucher.php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];
    $ext = pathinfo($_FILES['csv_file']['name'], PATHINFO_EXTENSION);

    if ($ext !== 'csv') {
        $_SESSION['flashMessage'] = ['text' => $lang[$current_lang]['invalid_format'] ?? 'Invalid format', 'type' => 'error'];
        header('Location: ../view/voucher.php');
        exit;
    }

    if (($handle = fopen($file, "r")) !== FALSE) {
        // Lewati baris header pertama
        fgetcsv($handle, 1000, ",");

        // Query disesuaikan dengan database baru
        // Urutan: code, location_id, nama_paket, durasi_hari, price, tanggal_pembuatan, link, status
        $stmt = $pdo->prepare("INSERT INTO vouchers (code, location_id, nama_paket, durasi_hari, price, tanggal_pembuatan, link, status) 
                               VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
        
        $count = 0;
        while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
            // Mapping Data CSV (Index berdasarkan urutan kolom di template)
            // 0 = code
            // 1 = location_id
            // 2 = nama_paket
            // 3 = durasi_hari
            // 4 = price
            // 5 = tanggal_pembuatan
            // 6 = link
            // 7 = status
            
            // Validasi sederhana: code, nama_paket, durasi_hari, dan price wajib diisi
            if (!empty($data[0]) && !empty($data[2]) && !empty($data[3]) && !empty($data[4])) {
                
                // Bersihkan data
                $code = $data[0];
                $location_id = !empty($data[1]) ? $data[1] : NULL;
                $nama_paket = $data[2];
                $durasi_hari = (int)$data[3]; // Pastikan integer
                $price = $data[4];
                $tanggal_pembuatan = !empty($data[5]) ? $data[5] : NULL;
                $link = !empty($data[6]) ? $data[6] : NULL;
                $status = !empty($data[7]) ? $data[7] : 'active';

                $stmt->execute([
                    $code,
                    $location_id,
                    $nama_paket,
                    $durasi_hari,
                    $price,
                    $tanggal_pembuatan,
                    $link,
                    $status
                ]);
                $count++;
            }
        }
        fclose($handle);
        
        $_SESSION['flashMessage'] = ['text' => ($lang[$current_lang]['import_success'] ?? 'Import Success') . " ($count rows)", 'type' => 'success'];
    } else {
        $_SESSION['flashMessage'] = ['text' => $lang[$current_lang]['import_error'] ?? 'Import Error', 'type' => 'error'];
    }

    header('Location: ../view/voucher.php');
    exit;
}
?>