<?php
// post/global_reset.php
require_once '../config/config.php';

// Header JSON
header('Content-Type: application/json');

// Cek Hak Akses
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized Access']);
    exit;
}

 $tables = $_POST['reset_table'] ?? [];
 $message = 'No action performed';

try {
    if (!empty($tables)) {
        // 1. Nonaktifkan Foreign Key Checks sementara
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 0");

        // 2. Eksekusi Truncate (Tanpa Transaction karena TRUNCATE auto-commit)
        if (in_array('konsumen', $tables)) {
            $pdo->exec("TRUNCATE TABLE konsumen");
        }
        if (in_array('penjualan_voucher', $tables)) {
            $pdo->exec("TRUNCATE TABLE penjualan_voucher");
        }
        if (in_array('vouchers', $tables)) {
            $pdo->exec("TRUNCATE TABLE vouchers");
        }

        // 3. Aktifkan kembali Foreign Key Checks
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 1");

        $message = 'Success! Data cleared: ' . implode(', ', $tables);
        echo json_encode(['status' => 'success', 'message' => $message]);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'No table selected']);
    }

} catch (PDOException $e) {
    // Pastikan FK diaktifkan kembali jika terjadi error
    try { 
        $pdo->exec("SET FOREIGN_KEY_CHECKS = 1"); 
    } catch (Exception $ex) {}

    echo json_encode(['status' => 'error', 'message' => 'Database Error: ' . $e->getMessage()]);
}