<?php
// post/delete_voucher.php
require_once '../config/config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    
    try {
        $stmt = $pdo->prepare("DELETE FROM vouchers WHERE id = ?");
        $stmt->execute([$id]);
        
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['delete_success'] ?? 'Data berhasil dihapus',
            'type' => 'success'
        ];
    } catch (PDOException $e) {
        $_SESSION['flashMessage'] = [
            'text' => $lang[$current_lang]['delete_error'] ?? 'Gagal menghapus data',
            'type' => 'error'
        ];
    }
}

header('Location: ../view/voucher.php');
exit;
?>