<?php
// post/add_location.php
require_once '../config/config.php';
header('Content-Type: application/json');

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

 $name = $_POST['name'] ?? '';
 $hotspot_link = $_POST['hotspot_link'] ?? ''; // Ambil data link

if (empty($name)) {
    echo json_encode(['status' => 'error', 'message' => 'Name is required']);
    exit;
}

try {
    // Query diupdate untuk menyertakan hotspot_link
    $stmt = $pdo->prepare("INSERT INTO locations (name, hotspot_link) VALUES (?, ?)");
    $stmt->execute([$name, $hotspot_link]);
    
    echo json_encode(['status' => 'success', 'message' => 'Location added successfully']);
} catch (PDOException $e) {
    // Cek error duplicate entry
    if ($e->errorInfo[1] == 1062) {
        echo json_encode(['status' => 'error', 'message' => 'Location name already exists']);
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Database error: ' . $e->getMessage()]);
    }
}