<?php
// includes/sidebar.php
// Variabel $activePage seharusnya dikirim dari file view (voucher.php, dashboard.php, dll)
 $activePage = $activePage ?? 'dashboard';
?>
        <!-- Sidebar -->
        <aside class="sidebar" id="sidebar">
            <div class="sidebar-header">
                <a href="dashboard.php" class="sidebar-logo">
                    <div class="logo-icon">
                        <svg viewBox="0 0 48 48" fill="none">
                            <path d="M24 4L42 14V34L24 44L6 34V14L24 4Z" stroke="currentColor" stroke-width="2" fill="none"/>
                            <path d="M24 14L33 19.5V30.5L24 36L15 30.5V19.5L24 14Z" fill="currentColor" opacity="0.3"/>
                            <circle cx="24" cy="24" r="4" fill="currentColor"/>
                        </svg>
                    </div>
                    <div class="logo-text">
                        <h1><?= htmlspecialchars($app_setting['app_name'] ?? 'SmartWifi') ?></h1>
                        <span>Management</span>
                    </div>
                </a>
            </div>
            
            <nav class="sidebar-menu">
                <div class="menu-section">
                    <div class="menu-section-title">Main Menu</div>
                    
                    <!-- Menu Dashboard -->
                    <a href="dashboard.php" class="menu-item <?= ($activePage == 'dashboard') ? 'active' : '' ?>">
                        <i class="mdi mdi-view-dashboard"></i>
                        <span><?= $lang[$current_lang]['dashboard'] ?></span>
                    </a>

                    <?php if ($_SESSION['role'] === 'admin'): ?>
                    <!-- Menu Router Management (Dinamis) -->
                    <a href="add_router.php" class="menu-item <?= ($activePage == 'add_router') ? 'active' : '' ?>">
                        <i class="mdi mdi-router-wireless"></i>
                        <span><?= $lang[$current_lang]['manage_routers'] ?? 'Manage Routers' ?></span>
                    </a>
                    
                    <!-- Menu Voucher -->
                    <a href="voucher.php" class="menu-item <?= ($activePage == 'voucher') ? 'active' : '' ?>">
                        <i class="mdi mdi-ticket-percent"></i>
                        <span><?= $lang[$current_lang]['voucher'] ?? 'Voucher' ?></span>
                    </a>
                    <?php endif; ?>

                    <!-- Menu Consumer -->
                    <a href="konsumen.php" class="menu-item <?= ($activePage == 'konsumen') ? 'active' : '' ?>">
                         <i class="mdi mdi-account-multiple"></i>
                         <span><?= $lang[$current_lang]['consumer'] ?? 'Consumer' ?></span>
                    </a>

                    <?php if ($_SESSION['role'] === 'admin'): ?>
                    <!-- Menu Locations -->
                    <a href="lokasi.php" class="menu-item <?= ($activePage == 'locations') ? 'active' : '' ?>">
                        <i class="mdi mdi-map-marker"></i>
                        <span><?= $lang[$current_lang]['locations'] ?? 'Locations' ?></span>
                    </a>
                    <?php endif; ?>

                    <!-- Menu Reports -->
                    <a href="reports.php" class="menu-item <?= ($activePage == 'reports') ? 'active' : '' ?>">
                         <i class="mdi mdi-file-chart"></i>
                         <span><?= $lang[$current_lang]['reports'] ?? 'Reports' ?></span>
                    </a>
                </div>
                
                <?php if ($_SESSION['role'] === 'admin'): ?>
                <div class="menu-section">
                    <div class="menu-section-title">Administration</div>
                    <a href="users.php" class="menu-item <?= ($activePage == 'users') ? 'active' : '' ?>">
                        <i class="mdi mdi-account-group"></i>
                        <span><?= $lang[$current_lang]['users'] ?></span>
                    </a>
                    <a href="settings.php" class="menu-item <?= ($activePage == 'settings') ? 'active' : '' ?>">
                        <i class="mdi mdi-cog-outline"></i>
                        <span><?= $lang[$current_lang]['settings'] ?></span>
                    </a>
                    <a href="reset.php" class="menu-item <?= ($activePage == 'reset') ? 'active' : '' ?>">
                        <i class="mdi mdi-recycle-variant"></i>
                        <span><?= $lang[$current_lang]['reset_data'] ?? 'Reset Data' ?></span>
                    </a>
                </div>
                <?php endif; ?>
            </nav>
            
            <div class="sidebar-footer">
                <div class="user-info">
                    <div class="user-avatar">
                        <?= strtoupper(substr($_SESSION['name'], 0, 1)) ?>
                    </div>
                    <div class="user-details">
                        <h4><?= htmlspecialchars($_SESSION['name']) ?></h4>
                        <span><?= ucfirst($_SESSION['role']) ?></span>
                    </div>
                </div>
            </div>
        </aside>