<?php
/* File: includes/routeros_api.php */
class RouterosAPI {
    public $connected = false;
    private $socket = null;

    public function connect($ip, $login, $password, $port = 8728) {
        // 1. Set Timeout Koneksi 3 Detik
        $this->socket = @fsockopen($ip, $port, $errno, $errstr, 3);
        
        if (!$this->socket) {
            return false; // Gagal koneksi
        }
        
        // 2. Set Timeout Baca/Tulis 2 Detik (PENTING UNTUK MENGHENTIKAN LOADING)
        stream_set_timeout($this->socket, 2); 

        // Login Process
        $this->write('/login');
        $response = $this->read(false);
        
        if (isset($response[0]) && strpos($response[0], '!done') !== false) {
            if (isset($response[1]) && strpos($response[1], '=ret=') !== false) {
                // Challenge Response (MD5)
                $matches = [];
                preg_match('/=ret=([a-f0-9]+)/', $response[1], $matches);
                if(isset($matches[1])) {
                    $chal = pack('H*', $matches[1]);
                    $md5 = md5(chr(0) . $password . $chal, true);
                    
                    $this->write('/login', false);
                    $this->write('=name=' . $login, false);
                    $this->write('=response=00' . bin2hex($md5));
                }
            } else {
                // Plain Login
                $this->write('/login', false);
                $this->write('=name=' . $login, false);
                $this->write('=password=' . $password);
            }
            
            $response = $this->read(false);
            if (isset($response[0]) && strpos($response[0], '!done') !== false) {
                $this->connected = true;
                return true;
            }
        }
        
        // Jika login gagal
        if ($this->socket) fclose($this->socket);
        return false;
    }

    public function disconnect() {
        if ($this->socket) {
            fclose($this->socket);
            $this->socket = null;
        }
        $this->connected = false;
    }

    public function comm($path, $params = []) {
        $this->write($path, false);
        foreach ($params as $k => $v) $this->write('=' . $k . '=' . $v, false);
        fwrite($this->socket, chr(0)); // End of command
        return $this->read(true);
    }

    private function write($str, $end = true) {
        if (!$this->socket) return;
        $len = strlen($str);
        if ($len < 0x80) fwrite($this->socket, chr($len));
        elseif ($len < 0x4000) { fwrite($this->socket, chr(($len >> 8) | 0x80)); fwrite($this->socket, chr($len & 0xFF)); }
        else { fwrite($this->socket, chr(0x81)); fwrite($this->socket, chr(($len >> 8) & 0xFF)); fwrite($this->socket, chr($len & 0xFF)); }
        
        fwrite($this->socket, $str);
        if ($end) fwrite($this->socket, chr(0));
    }

    private function read($parse) {
        $res = [];
        $buf = '';
        
        // Loop pembacaan data
        while (true) {
            // Baca panjang byte
            $byte = fread($this->socket, 1);
            
            // Jika kosong, kemungkinan timeout atau koneksi putus
            if (strlen($byte) == 0) break;

            $len = ord($byte);
            
            // Handling panjang data (1-2 byte)
            if (($len & 0xC0) == 0x80) {
                $byte2 = fread($this->socket, 1);
                if (strlen($byte2) == 0) break;
                $len = (($len & 0x3F) << 8) + ord($byte2);
            }

            // Jika Length = 0 -> End of Sentence (berhenti baca)
            if ($len == 0) {
                $res[] = $buf;
                $buf = '';
                
                // Khusus untuk API, jika sudah dapat !done, hentikan bacaan
                // agar tidak menunggu data lain yang tidak ada.
                if (strpos($buf, '!done') !== false || strpos($buf, '!trap') !== false) {
                    break;
                }
                continue;
            }

            // Baca konten sesuai panjang
            $ret = fread($this->socket, $len);
            if (strlen($ret) == 0) break; // Timeout protection
            
            $buf .= $ret;
        }
        
        // Parsing hasil array
        if ($parse) {
            $parsed = []; 
            $cur = [];
            foreach ($res as $r) {
                if (strpos($r, '=') === 0) { 
                    $p = explode('=', $r, 3); 
                    $cur[$p[1]] = (isset($p[2]) ? $p[2] : ''); 
                }
                elseif (strpos($r, '!') === 0) { /* skip */ }
                else { 
                    if (!empty($cur)) $parsed[] = $cur; 
                    $cur = []; 
                }
            }
            if (!empty($cur)) $parsed[] = $cur;
            return $parsed;
        }
        return $res;
    }
}
?>