<?php
// get/get_routers.php
require_once '../config/config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

try {
    // Tambahkan 'connectivity' di query SELECT
    $stmt = $pdo->query("SELECT id, name, ip, port, username, status, connectivity FROM routers ORDER BY created_at DESC");
    $routers = $stmt->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode([
        'data' => $routers
    ]);

} catch (PDOException $e) {
    echo json_encode([
        'status' => 'error', 
        'message' => 'Database Error: ' . $e->getMessage(),
        'data' => []
    ]);
}
?>