<?php
// get/get_router_stats.php

// PENTING: Batasi waktu eksekusi script maksimal 10 detik
set_time_limit(10); 

// MATIKAN ERROR DISPLAY (Hanya tampilkan error fatal, tapi biarkan JSON tetap jalan)
ini_set('display_errors', 0);
error_reporting(0);

require_once '../config/config.php';
header('Content-Type: application/json; charset=utf-8');

function response($data) {
    echo json_encode($data);
    exit;
}

// 1. Load Library
 $lib_path = __DIR__ . '/../includes/routeros_api.php';
if (!file_exists($lib_path)) {
    response(['status' => 'error', 'message' => 'Library file missing.']);
}
require_once $lib_path;

// 2. Get ID
if (!isset($_GET['id'])) response(['status' => 'error', 'message' => 'ID missing']);
 $id = (int)$_GET['id'];

// 3. Get Router Data
try {
    $stmt = $pdo->prepare("SELECT * FROM routers WHERE id = ?");
    $stmt->execute([$id]);
    $router = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$router) response(['status' => 'error', 'message' => 'Router not found']);
} catch (Exception $e) {
    response(['status' => 'error', 'message' => 'DB Error']);
}

// Default Data
 $data = [
    'cpu_load' => 0, 'active_users' => 0, 'total_users' => 0, 'expired_today' => 0,
    'board_name' => '-', 'uptime' => '-', 'version' => '-', 'free_memory' => '-',
    'rx_speed' => 0, 'tx_speed' => 0, 'logs' => []
];

 $API = new RouterosAPI();
 $port = !empty($router['port']) ? $router['port'] : 8728;

// 4. Connect
if ($API->connect($router['ip'], $router['username'], $router['password'], $port)) {
    // Resource
    $res = $API->comm('/system/resource/print');
    if (isset($res[0])) {
        $r = $res[0];
        $data['cpu_load'] = $r['cpu-load'] ?? 0;
        $data['board_name'] = $r['board-name'] ?? '-';
        $data['uptime'] = $r['uptime'] ?? '-';
        $data['version'] = $r['version'] ?? '-';
        $data['free_memory'] = round(($r['free-memory'] ?? 0) / 1048576, 2) . ' MB';
    }

    // Users
    $active = $API->comm('/ip/hotspot/active/print');
    $data['active_users'] = count($active);

    $users = $API->comm('/ip/hotspot/user/print');
    $data['total_users'] = count($users);

    $expCount = 0;
    foreach($users as $u) { if(isset($u['disabled']) && $u['disabled']=='true') $expCount++; }
    $data['expired_today'] = $expCount;

    // Traffic Dummy
    $data['rx_speed'] = rand(200, 1000);
    $data['tx_speed'] = rand(100, 500);

    $API->disconnect();
    
    response(['status' => 'success', 'data' => $data]);
} else {
    // Jika koneksi gagal, kirim status error (bukan loading terus)
    response(['status' => 'error', 'message' => 'Connection Failed. Check IP/Port/Firewall.']);
}
?>