<?php
// get/change_size.php
require_once '../config/config.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: ../index.php');
    exit;
}

// Ambil parameter dari URL
 $type = $_GET['type'] ?? 'text'; // text, btn, icon
 $size = $_GET['size'] ?? 'm';    // xs, m, l

// Mapping nama kolom di database berdasarkan tipe
 $column_map = [
    'text' => 'text_size',
    'btn'  => 'btn_size',
    'icon' => 'icon_size'
];

// Validasi
 $allowed_sizes = ['xs', 'm', 'l'];

if (array_key_exists($type, $column_map) && in_array($size, $allowed_sizes)) {
    $column_name = $column_map[$type];
    
    try {
        // 1. Update ke Database (Dynamic Column)
        // Kita whitelist $column_name di $column_map, jadi aman dari SQL Injection
        $stmt = $pdo->prepare("UPDATE users SET $column_name = ? WHERE id = ?");
        $stmt->execute([$size, $_SESSION['user_id']]);

        // 2. Update Session
        $_SESSION[$column_name] = $size;
        
        $_SESSION['flashMessage'] = [
            'text' => 'Size updated',
            'type' => 'success'
        ];
    } catch (PDOException $e) {
        $_SESSION['flashMessage'] = [
            'text' => 'Failed to update size',
            'type' => 'error'
        ];
    }
}

header('Location: ' . $_SERVER['HTTP_REFERER']);
exit;